/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.utils.DataUnit;
import cn.taketoday.context.utils.StringUtils;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataSize
implements Comparable<DataSize> {
    private static final Pattern PATTERN = Pattern.compile("^([+\\-]?\\d+)([a-zA-Z]{0,2})$");
    private final long bytes;

    private DataSize(long bytes) {
        this.bytes = bytes;
    }

    public static DataSize ofBytes(long bytes) {
        return new DataSize(bytes);
    }

    public static DataSize ofKilobytes(long kilobytes) {
        return new DataSize(Math.multiplyExact(kilobytes, 1024L));
    }

    public static DataSize ofMegabytes(long megabytes) {
        return new DataSize(Math.multiplyExact(megabytes, 0x100000L));
    }

    public static DataSize ofGigabytes(long gigabytes) {
        return new DataSize(Math.multiplyExact(gigabytes, 0x40000000L));
    }

    public static DataSize ofTerabytes(long terabytes) {
        return new DataSize(Math.multiplyExact(terabytes, 0x10000000000L));
    }

    public static DataSize of(long amount) {
        return DataSize.of(amount, DataUnit.BYTES);
    }

    public static DataSize of(long amount, DataUnit unit) {
        return new DataSize(Math.multiplyExact(amount, unit.size().toBytes()));
    }

    public static DataSize parse(CharSequence text) {
        return DataSize.parse(text, DataUnit.BYTES);
    }

    public static DataSize parse(CharSequence text, DataUnit defaultUnit) {
        try {
            Matcher matcher = PATTERN.matcher(text);
            if (matcher.matches()) {
                long amount = Long.parseLong(matcher.group(1));
                DataUnit unit = DataSize.determineDataUnit(matcher.group(2), defaultUnit);
                return DataSize.of(amount, unit);
            }
            return DataSize.of(Long.parseLong(text.toString()), DataUnit.BYTES);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("'" + text + "' is not a valid data size", ex);
        }
    }

    private static DataUnit determineDataUnit(String suffix, DataUnit defaultUnit) {
        return StringUtils.isNotEmpty(suffix) ? DataUnit.fromSuffix(suffix) : Objects.requireNonNull(defaultUnit);
    }

    public boolean isNegative() {
        return this.bytes < 0L;
    }

    public long toBytes() {
        return this.bytes;
    }

    public long toKilobytes() {
        return this.bytes / 1024L;
    }

    public long toMegabytes() {
        return this.bytes / 0x100000L;
    }

    public long toGigabytes() {
        return this.bytes / 0x40000000L;
    }

    public long toTerabytes() {
        return this.bytes / 0x10000000000L;
    }

    @Override
    public int compareTo(DataSize other) {
        return Long.compare(this.bytes, other.bytes);
    }

    public String toString() {
        return String.format("%dB", this.bytes);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof DataSize && this.bytes == ((DataSize)other).bytes;
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }
}

