/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.exception.ConversionException;
import cn.taketoday.context.utils.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class NumberUtils {
    public static Object parseDigit(String text, Class<?> targetClass) {
        if (StringUtils.isEmpty(text)) {
            return 0;
        }
        if (Byte.class == targetClass || Byte.TYPE == targetClass) {
            return Byte.valueOf(text);
        }
        if (Short.class == targetClass || Short.TYPE == targetClass) {
            return Short.valueOf(text);
        }
        if (Integer.class == targetClass || Integer.TYPE == targetClass) {
            return Integer.valueOf(text);
        }
        if (Long.class == targetClass || Long.TYPE == targetClass) {
            return Long.valueOf(text);
        }
        if (BigInteger.class == targetClass) {
            return new BigInteger(text);
        }
        if (Float.class == targetClass || Float.TYPE == targetClass) {
            return Float.valueOf(text);
        }
        if (Double.class == targetClass || Double.TYPE == targetClass) {
            return Double.valueOf(text);
        }
        if (BigDecimal.class == targetClass || Number.class == targetClass) {
            return BigDecimal.valueOf(Double.parseDouble(text));
        }
        throw new ConversionException("can't convert[" + text + "] to [" + targetClass.getName() + "]");
    }

    public static boolean isNumber(Class<?> targetClass) {
        return Number.class.isAssignableFrom(targetClass) || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE || targetClass == Short.TYPE || targetClass == Byte.TYPE;
    }
}

