/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.DecoratingProxy;
import cn.taketoday.context.Ordered;
import cn.taketoday.context.annotation.Order;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public abstract class OrderUtils {
    public static int getOrder(AnnotatedElement annotated) {
        Assert.notNull((Object)annotated, "AnnotatedElement must not be null");
        Order order = annotated.getAnnotation(Order.class);
        if (order != null) {
            return order.value();
        }
        return 0;
    }

    public static int getOrder(Object obj) {
        if (obj instanceof Ordered) {
            return ((Ordered)obj).getOrder();
        }
        if (obj instanceof AnnotatedElement) {
            return OrderUtils.getOrder((AnnotatedElement)obj);
        }
        if (obj instanceof DecoratingProxy) {
            return OrderUtils.getOrder(((DecoratingProxy)obj).getDecoratedClass());
        }
        return OrderUtils.getOrder(ClassUtils.getUserClass(obj));
    }

    public static Comparator<Object> getReversedComparator() {
        return OrderUtils.getComparator().reversed();
    }

    public static Comparator<Object> getComparator() {
        return Comparator.comparingInt(OrderUtils::getOrder);
    }

    public static <T> List<T> reversedSort(List<T> list) {
        Assert.notNull(list, "List must not be null");
        list.sort(OrderUtils.getReversedComparator());
        return list;
    }

    public static <T> List<T> sort(List<T> list) {
        Assert.notNull(list, "List must not be null");
        list.sort(OrderUtils.getComparator());
        return list;
    }

    public static <T> T[] sort(T[] array) {
        Assert.notNull(array, "array must not be null");
        Arrays.sort(array, OrderUtils.getComparator());
        return array;
    }

    public static <T> T[] reversedSort(T[] array) {
        Assert.notNull(array, "array must not be null");
        Arrays.sort(array, OrderUtils.getReversedComparator());
        return array;
    }
}

