/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.utils.Assert;
import java.util.function.Supplier;

public class SingletonSupplier<T>
implements Supplier<T> {
    private volatile T singletonInstance;
    private final Supplier<? extends T> defaultSupplier;
    private final Supplier<? extends T> instanceSupplier;

    public SingletonSupplier(T instance, Supplier<? extends T> defaultSupplier) {
        this.instanceSupplier = null;
        this.singletonInstance = instance;
        this.defaultSupplier = defaultSupplier;
    }

    public SingletonSupplier(Supplier<? extends T> instanceSupplier, Supplier<? extends T> defaultSupplier) {
        this.defaultSupplier = defaultSupplier;
        this.instanceSupplier = instanceSupplier;
    }

    private SingletonSupplier(Supplier<? extends T> supplier) {
        this.defaultSupplier = null;
        this.instanceSupplier = supplier;
    }

    private SingletonSupplier(T singletonInstance) {
        this.defaultSupplier = null;
        this.instanceSupplier = null;
        this.singletonInstance = singletonInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T instance = this.singletonInstance;
        if (instance == null) {
            SingletonSupplier singletonSupplier = this;
            synchronized (singletonSupplier) {
                instance = this.singletonInstance;
                if (instance == null) {
                    if (this.instanceSupplier != null) {
                        instance = this.instanceSupplier.get();
                    }
                    if (instance == null && this.defaultSupplier != null) {
                        instance = this.defaultSupplier.get();
                    }
                    this.singletonInstance = instance;
                }
            }
        }
        return instance;
    }

    public T obtain() {
        T instance = this.get();
        Assert.state(instance != null, "No instance from Supplier");
        return instance;
    }

    public static <T> SingletonSupplier<T> of(T instance) {
        return new SingletonSupplier<T>(instance);
    }

    public static <T> SingletonSupplier<T> ofNullable(T instance) {
        return instance != null ? new SingletonSupplier<T>(instance) : null;
    }

    public static <T> SingletonSupplier<T> of(Supplier<T> supplier) {
        return new SingletonSupplier<Supplier<T>>(supplier);
    }

    public static <T> SingletonSupplier<T> ofNullable(Supplier<T> supplier) {
        return supplier != null ? new SingletonSupplier<Supplier<Supplier<Supplier<Supplier<T>>>>>(supplier) : null;
    }
}

