/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.Constant;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ObjectUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;

public abstract class StringUtils {
    private static final int caseDiff = 32;
    private static final BitSet dontNeedEncoding;
    private static final Random random;

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isArrayNotEmpty(String ... strs) {
        return strs != null && strs.length != 0;
    }

    public static boolean isArrayEmpty(String ... strs) {
        return strs == null || strs.length == 0;
    }

    public static String[] split(String source) {
        char[] chars;
        if (source == null) {
            return Constant.EMPTY_STRING_ARRAY;
        }
        if (source.isEmpty()) {
            return new String[]{source};
        }
        ArrayList<String> list = new ArrayList<String>();
        int idx = 0;
        int start = 0;
        for (char c : chars = source.toCharArray()) {
            if (StringUtils.isSplitable(c)) {
                list.add(new String(chars, start, idx - start));
                start = idx + 1;
            }
            ++idx;
        }
        if (idx != start && idx == source.length()) {
            list.add(new String(chars, start, idx - start));
        } else if (list.isEmpty()) {
            return new String[]{source};
        }
        return list.toArray(new String[list.size()]);
    }

    static boolean isSplitable(char c) {
        return c == ',' || c == ';';
    }

    public static String decodeUrl(String s) {
        return StringUtils.decodeUrl(s, Constant.DEFAULT_CHARSET);
    }

    public static String decodeUrl(String s, Charset charset) {
        Assert.notNull((Object)charset, "Charset cannot be null");
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, charset));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    public static String encodeUrl(String s) {
        return StringUtils.encodeUrl(s, Constant.DEFAULT_CHARSET);
    }

    public static String encodeUrl(String s, Charset charset) {
        Assert.notNull((Object)charset, "Charset cannot be null");
        boolean needToChange = false;
        int length = s.length();
        StringBuilder out = new StringBuilder(length);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        BitSet dontNeedEncoding = StringUtils.dontNeedEncoding;
        int caseDiff = 32;
        int i = 0;
        while (i < length) {
            char c;
            int c2 = s.charAt(i);
            if (dontNeedEncoding.get(c2)) {
                if (c2 == 32) {
                    c2 = 43;
                    needToChange = true;
                }
                out.append((char)c2);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c2);
                if (c2 >= 55296 && c2 <= 56319 && i + 1 < length && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    charArrayWriter.write(d);
                    ++i;
                }
                if (++i >= length) break;
                c = s.charAt(i);
                c2 = c;
            } while (!dontNeedEncoding.get(c));
            charArrayWriter.flush();
            byte[] ba = new String(charArrayWriter.toCharArray()).getBytes(charset);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return Constant.EMPTY_STRING_ARRAY;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    public static String arrayToString(Object[] array) {
        return StringUtils.arrayToString(array, ",");
    }

    public static String arrayToString(Object[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        if (length == 1) {
            return array[0].toString();
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(array[i]);
            if (i == length - 1) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static <T> String collectionToString(Collection<T> collection) {
        return StringUtils.collectionToString(collection, ",");
    }

    public static <T> String collectionToString(Collection<T> coll, String delimiter) {
        if (coll == null) {
            return null;
        }
        int length = coll.size();
        if (length == 1) {
            Object target = coll instanceof List ? ((List)coll).get(0) : coll.iterator().next();
            return target != null ? target.toString() : null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (T target : coll) {
            builder.append(target);
            if (i++ == length - 1) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String checkPropertiesName(String fileName) {
        return fileName.endsWith(".properties") ? fileName : fileName + ".properties";
    }

    public static String getUUIDString() {
        return UUID.randomUUID().toString();
    }

    public static String readAsText(InputStream inputStream) throws IOException {
        return StringUtils.readAsText(inputStream, 8192);
    }

    public static String readAsText(InputStream inputStream, int bufferSize) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream(bufferSize);
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        buffer = null;
        return result.toString();
    }

    public static String cleanPath(String path) {
        int i;
        if (StringUtils.isEmpty(path)) {
            return path;
        }
        String pathToUse = StringUtils.replace(path, "\\", "/");
        if (pathToUse.indexOf(46) == -1) {
            return pathToUse;
        }
        int prefixIndex = pathToUse.indexOf(58);
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains("/")) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.delimitedListToStringArray(pathToUse, "/");
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (".".equals(element)) continue;
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (pathArray.length == pathElements.size()) {
            return prefix.concat(pathToUse);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, "..");
        }
        if (pathElements.size() == 1 && "".equals(pathElements.getLast()) && !prefix.endsWith("/")) {
            pathElements.add(0, ".");
        }
        return prefix.concat(StringUtils.collectionToString(pathElements, "/"));
    }

    public static String checkUrl(String url) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        if (url.charAt(0) == '/') {
            return url;
        }
        return '/' + url;
    }

    public static void appendLine(BufferedReader reader, StringBuilder builder) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (StringUtils.isEmpty(inString) || StringUtils.isEmpty(oldPattern) || newPattern == null) {
            return inString;
        }
        int index = inString.indexOf(oldPattern);
        if (index == -1) {
            return inString;
        }
        int capacity = inString.length();
        if (newPattern.length() > oldPattern.length()) {
            capacity += 16;
        }
        StringBuilder sb = new StringBuilder(capacity);
        int pos = 0;
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString, pos, index);
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString, pos, inString.length());
        return sb.toString();
    }

    public static String capitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, false);
    }

    public static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (capitalize ? firstChar >= 'A' && firstChar <= 'Z' : firstChar >= 'a' && firstChar <= 'z') {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = capitalize ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar);
        return new String(chars, 0, chars.length);
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (StringUtils.isEmpty(inString) || StringUtils.isEmpty(charsToDelete)) {
            return inString;
        }
        int length = inString.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return StringUtils.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return Constant.EMPTY_STRING_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(StringUtils.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StringUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] concatenateStringArrays(String[] array1, String[] array2) {
        if (ObjectUtils.isEmpty(array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty(array2)) {
            return array1;
        }
        String[] newArr = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArr, 0, array1.length);
        System.arraycopy(array2, 0, newArr, array1.length, array2.length);
        return newArr;
    }

    public static boolean hasText(CharSequence str) {
        return StringUtils.isNotEmpty(str) && StringUtils.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf("/");
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf("/");
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static boolean simpleMatch(String pattern, String str) {
        if (pattern == null || str == null) {
            return false;
        }
        int firstIndex = pattern.indexOf(42);
        if (firstIndex == -1) {
            return pattern.equals(str);
        }
        if (firstIndex == 0) {
            if (pattern.length() == 1) {
                return true;
            }
            int nextIndex = pattern.indexOf(42, 1);
            if (nextIndex == -1) {
                return str.endsWith(pattern.substring(1));
            }
            String part = pattern.substring(1, nextIndex);
            if (part.isEmpty()) {
                return StringUtils.simpleMatch(pattern.substring(nextIndex), str);
            }
            int partIndex = str.indexOf(part);
            while (partIndex != -1) {
                if (StringUtils.simpleMatch(pattern.substring(nextIndex), str.substring(partIndex + part.length()))) {
                    return true;
                }
                partIndex = str.indexOf(part, partIndex + 1);
            }
            return false;
        }
        return str.length() >= firstIndex && pattern.substring(0, firstIndex).equals(str.substring(0, firstIndex)) && StringUtils.simpleMatch(pattern.substring(firstIndex), str.substring(firstIndex));
    }

    public static boolean simpleMatch(String[] patterns, String str) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!StringUtils.simpleMatch(pattern, str)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getRandomString(int length) {
        char[] ret = new char[length];
        Random random = StringUtils.random;
        for (int i = 0; i < length; ++i) {
            ret[i] = StringUtils.generateRandomCharacter(random.nextInt(3));
        }
        return String.valueOf(ret);
    }

    private static char generateRandomCharacter(int type) {
        switch (type) {
            case 0: {
                int rand = random.nextInt(26);
                return (char)(rand += 97);
            }
            case 1: {
                int rand = random.nextInt(26);
                return (char)(rand += 65);
            }
        }
        int rand = random.nextInt(10);
        return (char)(rand += 48);
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str) {
        return StringUtils.containsWhitespace((CharSequence)str);
    }

    public static String trimWhitespace(String str) {
        int beginIndex;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int endIndex = str.length() - 1;
        for (beginIndex = 0; beginIndex <= endIndex && Character.isWhitespace(str.charAt(beginIndex)); ++beginIndex) {
        }
        while (endIndex > beginIndex && Character.isWhitespace(str.charAt(endIndex))) {
            --endIndex;
        }
        return str.substring(beginIndex, endIndex + 1);
    }

    public static String trimAllWhitespace(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        int beginIdx;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        for (beginIdx = 0; beginIdx < str.length() && Character.isWhitespace(str.charAt(beginIdx)); ++beginIdx) {
        }
        return str.substring(beginIdx);
    }

    public static String trimTrailingWhitespace(String str) {
        int endIdx;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        for (endIdx = str.length() - 1; endIdx >= 0 && Character.isWhitespace(str.charAt(endIdx)); --endIdx) {
        }
        return str.substring(0, endIdx + 1);
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        int beginIdx;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        for (beginIdx = 0; beginIdx < str.length() && leadingCharacter == str.charAt(beginIdx); ++beginIdx) {
        }
        return str.substring(beginIdx);
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        int endIdx;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        for (endIdx = str.length() - 1; endIdx >= 0 && trailingCharacter == str.charAt(endIdx); --endIdx) {
        }
        return str.substring(0, endIdx + 1);
    }

    public static boolean matchesCharacter(String str, char singleCharacter) {
        return str != null && str.length() == 1 && str.charAt(0) == singleCharacter;
    }

    public static Locale parseLocale(String localeValue) {
        String[] tokens = StringUtils.tokenizeLocaleSource(localeValue);
        if (tokens.length == 1) {
            StringUtils.validateLocalePart(localeValue);
            Locale resolved = Locale.forLanguageTag(localeValue);
            if (resolved.getLanguage().length() > 0) {
                return resolved;
            }
        }
        return StringUtils.parseLocaleTokens(localeValue, tokens);
    }

    public static Locale parseLocaleString(String localeString) {
        return StringUtils.parseLocaleTokens(localeString, StringUtils.tokenizeLocaleSource(localeString));
    }

    private static String[] tokenizeLocaleSource(String localeSource) {
        return StringUtils.tokenizeToStringArray(localeSource, "_ ", false, false);
    }

    private static Locale parseLocaleTokens(String localeString, String[] tokens) {
        int endIndexOfCountryCode;
        String language = tokens.length > 0 ? tokens[0] : "";
        String country = tokens.length > 1 ? tokens[1] : "";
        StringUtils.validateLocalePart(language);
        StringUtils.validateLocalePart(country);
        String variant = "";
        if (tokens.length > 2 && (variant = StringUtils.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country, language.length()) + country.length()))).startsWith("_")) {
            variant = StringUtils.trimLeadingCharacter(variant, '_');
        }
        if (variant.isEmpty() && country.startsWith("#")) {
            variant = country;
            country = "";
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static void validateLocalePart(String localePart) {
        for (int i = 0; i < localePart.length(); ++i) {
            char ch = localePart.charAt(i);
            if (ch == ' ' || ch == '_' || ch == '-' || ch == '#' || Character.isLetterOrDigit(ch)) continue;
            throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
        }
    }

    public static TimeZone parseTimeZoneString(String timeZoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        if ("GMT".equals(timeZone.getID()) && !timeZoneString.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + timeZoneString + "'");
        }
        return timeZone;
    }

    static {
        int i;
        random = new Random();
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

