/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.conversion.support.DefaultConversionService;
import cn.taketoday.context.utils.GenericDescriptor;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.ExpressionFactory;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.FunctionMapper;
import cn.taketoday.expression.ImportHandler;
import cn.taketoday.expression.PropertyNotFoundException;
import cn.taketoday.expression.VariableMapper;
import cn.taketoday.expression.lang.EvaluationContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;

public abstract class ExpressionContext {
    private boolean resolved;
    private HashMap<Class<?>, Object> map;
    private Stack<Map<String, Object>> lambdaArgs;
    private Locale locale;
    private ConversionService conversionService = DefaultConversionService.getSharedInstance();

    public void setPropertyResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public void setPropertyResolved(Object base, Object property) {
        this.setPropertyResolved(true);
    }

    public boolean isPropertyResolved() {
        return this.resolved;
    }

    public void putContext(Class<?> key, Object contextObject) {
        if (key == null || contextObject == null) {
            throw new NullPointerException();
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(key, contextObject);
    }

    public Object getContext(Class<?> key) {
        if (this.map == null || key == null) {
            return null;
        }
        return this.map.get(key);
    }

    public abstract ExpressionResolver getResolver();

    public ImportHandler getImportHandler() {
        return ImportHandler.getInstance();
    }

    public abstract FunctionMapper getFunctionMapper();

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public abstract VariableMapper getVariableMapper();

    public boolean isLambdaArgument(String arg) {
        Stack<Map<String, Object>> lambdaArgs = this.lambdaArgs;
        if (lambdaArgs == null) {
            return false;
        }
        int size = lambdaArgs.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!((Map)lambdaArgs.elementAt(i)).containsKey(arg)) continue;
            return true;
        }
        return false;
    }

    public Object getLambdaArgument(String arg) {
        Stack<Map<String, Object>> lambdaArgs = this.lambdaArgs;
        if (lambdaArgs == null) {
            return null;
        }
        int size = lambdaArgs.size();
        for (int i = size - 1; i >= 0; --i) {
            Object v = ((Map)lambdaArgs.elementAt(i)).get(arg);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public void enterLambdaScope(Map<String, Object> args) {
        if (this.lambdaArgs == null) {
            this.lambdaArgs = new Stack();
        }
        this.lambdaArgs.push(args);
    }

    public void exitLambdaScope() {
        if (this.lambdaArgs != null) {
            this.lambdaArgs.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convertToType(Object obj, Class<?> targetType) {
        boolean propertyResolvedSave = this.isPropertyResolved();
        try {
            this.setPropertyResolved(false);
            if (targetType.isInstance(obj)) {
                Object object = obj;
                return object;
            }
            GenericDescriptor targetDescriptor = GenericDescriptor.valueOf(targetType);
            TypeConverter typeConverter = this.conversionService.getConverter(obj.getClass(), targetDescriptor);
            if (typeConverter != null) {
                Object object = typeConverter.convert(targetDescriptor, obj);
                return object;
            }
            ExpressionResolver elResolver = this.getResolver();
            if (elResolver != null) {
                Object res = elResolver.convertToType(this, obj, targetType);
                if (this.isPropertyResolved()) {
                    Object object = res;
                    return object;
                }
            }
        }
        finally {
            this.setPropertyResolved(propertyResolvedSave);
        }
        return ExpressionFactory.getSharedInstance().coerceToType(obj, targetType);
    }

    public Object handlePropertyNotResolved(Object base, Object property, EvaluationContext ctx) throws ExpressionException {
        if (base == null) {
            throw new PropertyNotFoundException("ELResolver cannot handle a null base Object with identifier ''" + property + "''");
        }
        throw new PropertyNotFoundException("ELResolver did not handle type: " + base.getClass() + " with property of ''" + property + "''");
    }

    public void setConversionService(ConversionService conversionService) {
        if (conversionService == null) {
            conversionService = DefaultConversionService.getSharedInstance();
        }
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }
}

