/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.context.utils.ConcurrentCache;
import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.FunctionMapper;
import cn.taketoday.expression.MethodExpression;
import cn.taketoday.expression.MethodExpressionImpl;
import cn.taketoday.expression.MethodExpressionLiteral;
import cn.taketoday.expression.ValueExpression;
import cn.taketoday.expression.ValueExpressionImpl;
import cn.taketoday.expression.ValueExpressionLiteral;
import cn.taketoday.expression.VariableMapper;
import cn.taketoday.expression.lang.ExpressionUtils;
import cn.taketoday.expression.parser.AstDeferredExpression;
import cn.taketoday.expression.parser.AstDynamicExpression;
import cn.taketoday.expression.parser.AstFunction;
import cn.taketoday.expression.parser.AstIdentifier;
import cn.taketoday.expression.parser.AstLiteralExpression;
import cn.taketoday.expression.parser.AstMethodArguments;
import cn.taketoday.expression.parser.AstValue;
import cn.taketoday.expression.parser.ExpressionParser;
import cn.taketoday.expression.parser.Node;
import cn.taketoday.expression.parser.NodeVisitor;
import cn.taketoday.expression.stream.StreamExpressionResolver;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ExpressionFactory
implements NodeVisitor {
    private final Properties properties;
    private final Map<String, Method> functionMap = new HashMap<String, Method>();
    private static final String CACHE_SIZE_PROP = "expression.cache.size";
    private static final ExpressionFactory sharedExpressionFactory;
    private static final ConcurrentCache<String, Node> EXPRESSION_CACHE;

    public ExpressionFactory() {
        this(null);
    }

    public ExpressionFactory(Properties properties) {
        this.properties = properties;
    }

    public Object coerceToType(Object obj, Class<?> type) {
        try {
            return ExpressionUtils.coerceToType(obj, type);
        }
        catch (IllegalArgumentException ex) {
            throw new ExpressionException(ex);
        }
    }

    protected Node build(String expression, ExpressionContext context) {
        Node n = ExpressionFactory.createNode(expression);
        this.prepare(n, context);
        return n;
    }

    public MethodExpression createMethodExpression(ExpressionContext context, String expression, Class<?> expectedReturnType, Class<?>[] expectedParamTypes) {
        MethodExpression methodExpression;
        Node node = this.build(expression, context);
        if (node instanceof AstValue || node instanceof AstIdentifier) {
            methodExpression = new MethodExpressionImpl(expression, node, expectedParamTypes, expectedReturnType);
        } else if (node instanceof AstLiteralExpression) {
            methodExpression = new MethodExpressionLiteral(expression, expectedReturnType, expectedParamTypes);
        } else {
            throw new ExpressionException("Not a Valid Method Expression: " + expression);
        }
        if (expectedParamTypes == null && !((MethodExpression)methodExpression).isParametersProvided()) {
            throw new NullPointerException("Parameter types cannot be null");
        }
        return methodExpression;
    }

    public ValueExpression createValueExpression(ExpressionContext context, String expression, Class<?> expectedType) {
        return new ValueExpressionImpl(expression, this.build(expression, context), expectedType);
    }

    public ValueExpression createValueExpression(Object instance, Class<?> expectedType) {
        return new ValueExpressionLiteral(instance, expectedType);
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    public ExpressionResolver getStreamELResolver() {
        return StreamExpressionResolver.getInstance();
    }

    public Map<String, Method> getInitFunctionMap() {
        return this.functionMap;
    }

    public static Node createNode(String expr) throws ExpressionException {
        if (expr == null) {
            throw new ExpressionException("Expression cannot be null");
        }
        Node node = EXPRESSION_CACHE.get(expr);
        if (node == null) {
            node = ExpressionParser.parse(expr);
            int numChildren = node.jjtGetNumChildren();
            if (numChildren == 1) {
                node = node.jjtGetChild(0);
            } else {
                Class<?> type = null;
                for (int i = 0; i < numChildren; ++i) {
                    Node child = node.jjtGetChild(i);
                    if (child instanceof AstLiteralExpression) continue;
                    if (type == null) {
                        type = child.getClass();
                        continue;
                    }
                    if (type.equals(child.getClass())) continue;
                    throw new ExpressionException("Expression cannot contain both '#{..}' and '${..}' : " + expr);
                }
            }
            if (node instanceof AstDynamicExpression || node instanceof AstDeferredExpression) {
                node = node.jjtGetChild(0);
            }
            EXPRESSION_CACHE.put(expr, node);
        }
        return node;
    }

    protected void prepare(Node node, ExpressionContext context) {
        node.accept(this, context);
    }

    @Override
    public void visit(Node node, ExpressionContext context) {
        VariableMapper varMapper;
        if (node instanceof AstFunction) {
            FunctionMapper fnMapper = context.getFunctionMapper();
            VariableMapper varMapper2 = context.getVariableMapper();
            AstFunction funcNode = (AstFunction)node;
            String prefix = funcNode.getPrefix();
            if (prefix.isEmpty() && (fnMapper == null || fnMapper.resolveFunction(prefix, funcNode.getLocalName()) == null)) {
                if (varMapper2 != null) {
                    varMapper2.resolveVariable(funcNode.getLocalName());
                }
                return;
            }
            if (fnMapper == null) {
                throw new ExpressionException("Expression uses functions, but no FunctionMapper was provided");
            }
            Method m = fnMapper.resolveFunction(prefix, funcNode.getLocalName());
            if (m == null) {
                throw new ExpressionException("Function ''" + funcNode.getOutputName() + "'' not found");
            }
            int pcnt = m.getParameterTypes().length;
            int acnt = ((AstMethodArguments)node.jjtGetChild(0)).getParameterCount();
            if (acnt != pcnt) {
                throw new ExpressionException("Function ''" + funcNode.getOutputName() + "'' specifies " + pcnt + " params, but " + acnt + " were supplied");
            }
        } else if (node instanceof AstIdentifier && (varMapper = context.getVariableMapper()) != null) {
            varMapper.resolveVariable(node.getImage());
        }
    }

    public static ExpressionFactory getSharedInstance() {
        return sharedExpressionFactory;
    }

    static {
        String cacheSizeStr = System.getSecurityManager() == null ? System.getProperty(CACHE_SIZE_PROP, "2048") : AccessController.doPrivileged(() -> System.getProperty(CACHE_SIZE_PROP, "2048"));
        EXPRESSION_CACHE = new ConcurrentCache(Integer.parseInt(cacheSizeStr));
        sharedExpressionFactory = new ExpressionFactory();
    }
}

