/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.BeanNameExpressionResolver;
import cn.taketoday.expression.BeanNameResolver;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.ExpressionFactory;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.StandardExpressionContext;
import cn.taketoday.expression.ValueExpression;
import java.lang.reflect.Method;

public class ExpressionManager {
    private final StandardExpressionContext elContext;
    private final ExpressionFactory exprFactory;

    public ExpressionManager(StandardExpressionContext elContext, ExpressionFactory exprFactory) {
        this.elContext = elContext;
        this.exprFactory = exprFactory;
    }

    public ExpressionManager() {
        this.exprFactory = ExpressionFactory.getSharedInstance();
        this.elContext = new StandardExpressionContext(this.exprFactory);
    }

    public ExpressionFactory getExpressionFactory() {
        return this.exprFactory;
    }

    public StandardExpressionContext getContext() {
        return this.elContext;
    }

    public void addBeanNameResolver(BeanNameResolver bnr) {
        this.getContext().addResolver(new BeanNameExpressionResolver(bnr));
    }

    public void addResolver(ExpressionResolver elr) {
        this.getContext().addResolver(elr);
    }

    public void mapFunction(String prefix, String function, Method meth) {
        this.getContext().getFunctionMapper().mapFunction(prefix, function, meth);
    }

    public void setVariable(String variable, ValueExpression expression) {
        this.getContext().getVariableMapper().setVariable(variable, expression);
    }

    public void importStatic(String staticMemberName) throws ExpressionException {
        this.getContext().getImportHandler().importStatic(staticMemberName);
    }

    public void importClass(String className) throws ExpressionException {
        this.getContext().getImportHandler().importClass(className);
    }

    public void importClass(Class<?> clazz) throws ExpressionException {
        this.getContext().getImportHandler().importClass(clazz.getName());
    }

    public void importPackage(String packageName) {
        this.getContext().getImportHandler().importPackage(packageName);
    }

    public Object defineBean(String name, Object bean) {
        return this.getContext().getBeans().put(name, bean);
    }
}

