/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionFactory;
import cn.taketoday.expression.ExpressionManager;
import cn.taketoday.expression.StandardExpressionContext;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ExpressionProcessor {
    private final ExpressionFactory factory;
    private final ExpressionManager elManager;

    public ExpressionProcessor() {
        this(new ExpressionManager());
    }

    public ExpressionProcessor(ExpressionManager elManager) {
        this.elManager = elManager;
        this.factory = elManager.getExpressionFactory();
    }

    public ExpressionManager getManager() {
        return this.elManager;
    }

    public Object eval(String expression) {
        return this.getValue(expression, Object.class);
    }

    public <T> T getValue(String expression, Class<T> expectedType) {
        StandardExpressionContext elContext = this.elManager.getContext();
        return this.getValue(expression, elContext, expectedType);
    }

    public <T> T getValue(String expression, ExpressionContext context, Class<T> expectedType) {
        return (T)this.factory.createValueExpression(context, this.bracket(expression), expectedType).getValue(context);
    }

    public void setValue(String expression, Object value) {
        StandardExpressionContext elContext = this.elManager.getContext();
        this.factory.createValueExpression(elContext, this.bracket(expression), Object.class).setValue(elContext, value);
    }

    public void setVariable(String var, String expression) {
        this.elManager.setVariable(var, this.factory.createValueExpression(this.elManager.getContext(), this.bracket(expression), Object.class));
    }

    public void defineFunction(String prefix, String function, String className, String method) throws ClassNotFoundException, NoSuchMethodException {
        if (prefix == null || function == null || className == null || method == null) {
            throw new NullPointerException("Null argument for defineFunction");
        }
        Method meth = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        Class<?> klass = Class.forName(className, false, loader);
        int j = method.indexOf(40);
        if (j < 0) {
            for (Method m : klass.getDeclaredMethods()) {
                if (!m.getName().equals(method)) continue;
                meth = m;
            }
            if (meth == null) {
                throw new NoSuchMethodException("Bad method name: " + method);
            }
        } else {
            int p = method.indexOf(32);
            if (p < 0) {
                throw new NoSuchMethodException("Bad method singnature: " + method);
            }
            String methodName = method.substring(p + 1, j).trim();
            p = method.indexOf(41, j + 1);
            if (p < 0) {
                throw new NoSuchMethodException("Bad method singnature: " + method);
            }
            String[] params = method.substring(j + 1, p).split(",");
            Class[] paramTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramTypes[i] = ExpressionProcessor.toClass(params[i], loader);
            }
            meth = klass.getDeclaredMethod(methodName, paramTypes);
        }
        if (!Modifier.isStatic(meth.getModifiers())) {
            throw new NoSuchMethodException("The method specified in defineFunction must be static: " + meth);
        }
        if ("".equals(function)) {
            function = method;
        }
        this.elManager.mapFunction(prefix, function, meth);
    }

    public void defineFunction(String prefix, String function, Method method) throws NoSuchMethodException {
        if (prefix == null || function == null || method == null) {
            throw new NullPointerException("Null argument for defineFunction");
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("The method specified in defineFunction must be static: " + method);
        }
        if ("".equals(function)) {
            function = method.getName();
        }
        this.elManager.mapFunction(prefix, function, method);
    }

    public void defineBean(String name, Object bean) {
        this.elManager.defineBean(name, bean);
    }

    private static Class<?> toClass(String type, ClassLoader loader) throws ClassNotFoundException {
        Class<Serializable> c = null;
        int i0 = type.indexOf(91);
        int dims = 0;
        if (i0 > 0) {
            for (int i = 0; i < type.length(); ++i) {
                if (type.charAt(i) != '[') continue;
                ++dims;
            }
            type = type.substring(0, i0);
        }
        c = "boolean".equals(type) ? Boolean.TYPE : ("char".equals(type) ? Character.TYPE : ("byte".equals(type) ? Byte.TYPE : ("short".equals(type) ? Short.TYPE : ("int".equals(type) ? Integer.TYPE : ("long".equals(type) ? Long.TYPE : ("float".equals(type) ? Float.TYPE : ("double".equals(type) ? Double.TYPE : loader.loadClass(type))))))));
        if (dims == 0) {
            return c;
        }
        if (dims == 1) {
            return Array.newInstance(c, 1).getClass();
        }
        return Array.newInstance(c, new int[dims]).getClass();
    }

    private final String bracket(String expression) {
        if (expression == null) {
            return "${null}";
        }
        char firstChar = expression.charAt(0);
        if (firstChar == '#' || firstChar == '$') {
            return expression;
        }
        return "${" + expression + '}';
    }
}

