/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.expression.ExpressionException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ImportHandler {
    private static final ImportHandler INSTANCE = new ImportHandler();
    private final Map<String, Class<?>> classMap = new HashMap();
    private final Map<String, String> classNameMap = new HashMap<String, String>();
    private final Map<String, String> staticNameMap = new HashMap<String, String>();
    private final HashSet<String> notAClass = new HashSet();
    private final ArrayList<String> packages = new ArrayList();

    public ImportHandler() {
        this.importPackage("java.lang");
    }

    public static ImportHandler getInstance() {
        return INSTANCE;
    }

    public void importStatic(String name) throws ExpressionException {
        int i = name.lastIndexOf(46);
        if (i <= 0) {
            throw new ExpressionException("The name " + name + " is not a full static member name");
        }
        String memberName = name.substring(i + 1);
        String className = name.substring(0, i);
        this.staticNameMap.put(memberName, className);
    }

    public void importClass(String name) throws ExpressionException {
        int i = name.lastIndexOf(46);
        if (i <= 0) {
            throw new ExpressionException("The name " + name + " is not a full class name");
        }
        String className = name.substring(i + 1);
        this.classNameMap.put(className, name);
    }

    public void importPackage(String packageName) {
        this.packages.add(packageName);
    }

    public Class<?> resolveClass(String name) {
        Map<String, String> classNameMap = this.classNameMap;
        String className = classNameMap.get(name);
        if (className != null) {
            return this.resolveClassFor(className);
        }
        for (String packageName : this.packages) {
            String fullClassName = packageName + '.' + name;
            Class<?> c = this.resolveClassFor(fullClassName);
            if (c == null) continue;
            classNameMap.put(name, fullClassName);
            return c;
        }
        return null;
    }

    public Class<?> resolveStatic(String name) {
        String className = this.staticNameMap.get(name);
        if (className != null) {
            return this.resolveClassFor(className);
        }
        return null;
    }

    private Class<?> resolveClassFor(String className) {
        Class<?> c = this.classMap.get(className);
        if (c == null && (c = this.getClassFor(className)) != null) {
            this.checkModifiers(c.getModifiers());
            this.classMap.put(className, c);
        }
        return c;
    }

    private Class<?> getClassFor(String className) {
        if (!this.notAClass.contains(className)) {
            try {
                return ClassUtils.forName(className);
            }
            catch (ClassNotFoundException ex) {
                this.notAClass.add(className);
            }
        }
        return null;
    }

    private void checkModifiers(int modifiers) {
        if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new ExpressionException("Imported class must be public, and cannot be abstract or an interface");
        }
    }
}

