/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.ValueExpression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LambdaExpression {
    private final ExpressionContext context;
    private final ValueExpression expression;
    private final List<String> formalParameters;
    private final Map<String, Object> envirArgs;

    public LambdaExpression(List<String> formalParameters, ValueExpression expression, ExpressionContext context) {
        this.formalParameters = formalParameters;
        this.expression = expression;
        this.context = context;
        this.envirArgs = new HashMap<String, Object>();
    }

    public Object invoke(ExpressionContext elContext, Object ... args) throws ExpressionException {
        int i = 0;
        HashMap<String, Object> lambdaArgs = new HashMap<String, Object>(this.envirArgs);
        for (String fParam : this.formalParameters) {
            if (i >= args.length) {
                throw new ExpressionException("Expected Argument " + fParam + " missing in Lambda Expression");
            }
            lambdaArgs.put(fParam, args[i++]);
        }
        elContext.enterLambdaScope(lambdaArgs);
        Object ret = this.expression.getValue(elContext);
        if (ret instanceof LambdaExpression) {
            ((LambdaExpression)ret).envirArgs.putAll(lambdaArgs);
        }
        elContext.exitLambdaScope();
        return ret;
    }

    public Object invoke(Object ... args) {
        return this.invoke(this.context, args);
    }
}

