/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ArrayExpressionResolver;
import cn.taketoday.expression.BeanExpressionResolver;
import cn.taketoday.expression.BeanNameExpressionResolver;
import cn.taketoday.expression.CompositeExpressionResolver;
import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionFactory;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.FunctionMapper;
import cn.taketoday.expression.ListExpressionResolver;
import cn.taketoday.expression.MapExpressionResolver;
import cn.taketoday.expression.ResourceBundleExpressionResolver;
import cn.taketoday.expression.StaticFieldExpressionResolver;
import cn.taketoday.expression.ValueExpression;
import cn.taketoday.expression.VariableMapper;
import cn.taketoday.expression.lang.LocalBeanNameResolver;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class StandardExpressionContext
extends ExpressionContext {
    private final ExpressionResolver elResolver;
    private final CompositeExpressionResolver customResolvers;
    private final FunctionMapper functionMapper;
    private final VariableMapper variableMapper;
    private final Map<String, Object> beans = new HashMap<String, Object>(8);
    private final ExpressionContext delegate;

    public StandardExpressionContext(ExpressionFactory factory) {
        this.delegate = null;
        this.variableMapper = new DefaultVariableMapper();
        this.functionMapper = new DefaultFunctionMapper(factory.getInitFunctionMap());
        this.customResolvers = new CompositeExpressionResolver(2);
        CompositeExpressionResolver resolver = new CompositeExpressionResolver(this.customResolvers, new BeanNameExpressionResolver(new LocalBeanNameResolver(this.beans)), new StaticFieldExpressionResolver(), new MapExpressionResolver(), new ResourceBundleExpressionResolver(), new ListExpressionResolver(), new ArrayExpressionResolver());
        ExpressionResolver streamELResolver = factory.getStreamELResolver();
        if (streamELResolver != null) {
            resolver.add(streamELResolver);
        }
        resolver.add(new BeanExpressionResolver());
        this.elResolver = resolver;
    }

    public StandardExpressionContext(ExpressionContext context) {
        this.delegate = context;
        this.customResolvers = new CompositeExpressionResolver();
        this.elResolver = new CompositeExpressionResolver(this.customResolvers, new BeanNameExpressionResolver(new LocalBeanNameResolver(this.beans)), context.getResolver());
        this.functionMapper = context.getFunctionMapper();
        this.variableMapper = context.getVariableMapper();
        this.setLocale(context.getLocale());
    }

    @Override
    public void putContext(Class<?> key, Object contextObject) {
        if (this.delegate != null) {
            this.delegate.putContext(key, contextObject);
        } else {
            super.putContext(key, contextObject);
        }
    }

    @Override
    public Object getContext(Class<?> key) {
        if (this.delegate == null) {
            return super.getContext(key);
        }
        return this.delegate.getContext(key);
    }

    @Override
    public ExpressionResolver getResolver() {
        return this.elResolver;
    }

    public void addResolver(ExpressionResolver cELResolver) {
        this.customResolvers.add(cELResolver);
    }

    public Map<String, Object> getBeans() {
        return this.beans;
    }

    public Object defineBean(String name, Object bean) {
        return this.beans.put(name, bean);
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    @Override
    public VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    private static final class DefaultVariableMapper
    extends VariableMapper {
        private final Map<String, ValueExpression> variables = new HashMap<String, ValueExpression>();

        private DefaultVariableMapper() {
        }

        @Override
        public ValueExpression resolveVariable(String variable) {
            return this.variables.get(variable);
        }

        @Override
        public ValueExpression setVariable(String variable, ValueExpression expression) {
            if (expression == null) {
                return this.variables.remove(variable);
            }
            return this.variables.put(variable, expression);
        }
    }

    private static final class DefaultFunctionMapper
    extends FunctionMapper {
        private final Map<String, Method> functions;

        DefaultFunctionMapper(Map<String, Method> initMap) {
            this.functions = initMap == null ? new HashMap(16, 1.0f) : initMap;
        }

        @Override
        public Method resolveFunction(String prefix, String localName) {
            return this.functions.get(prefix + ":" + localName);
        }

        @Override
        public void mapFunction(String prefix, String localName, Method meth) {
            this.functions.put(prefix + ":" + localName, meth);
        }
    }
}

