/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.PropertyNotWritableException;
import cn.taketoday.expression.ValueExpression;

public final class ValueExpressionLiteral
extends ValueExpression {
    private final Object value;
    private final Class<?> expectedType;

    public ValueExpressionLiteral() {
        this(null, null);
    }

    public ValueExpressionLiteral(Object value, Class<?> expectedType) {
        this.value = value;
        this.expectedType = expectedType;
    }

    @Override
    public Object getValue(ExpressionContext context) {
        if (this.expectedType != null) {
            try {
                return context.convertToType(this.value, this.expectedType);
            }
            catch (IllegalArgumentException ex) {
                throw new ExpressionException(ex);
            }
        }
        return this.value;
    }

    @Override
    public void setValue(ExpressionContext context, Object value) {
        throw new PropertyNotWritableException("ValueExpression is a literal and not writable: " + this.value);
    }

    @Override
    public boolean isReadOnly(ExpressionContext context) {
        return true;
    }

    @Override
    public Class<?> getType(ExpressionContext context) {
        return this.value != null ? this.value.getClass() : null;
    }

    @Override
    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    @Override
    public String getExpressionString() {
        return this.value != null ? this.value.toString() : null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ValueExpressionLiteral && this.equals((ValueExpressionLiteral)obj);
    }

    public boolean equals(ValueExpressionLiteral ve) {
        return ve != null && this.value != null && ve.value != null && (this.value == ve.value || this.value.equals(ve.value));
    }

    @Override
    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public boolean isLiteralText() {
        return true;
    }
}

