/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.parser;

import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.ImportHandler;
import cn.taketoday.expression.MethodExpression;
import cn.taketoday.expression.MethodInfo;
import cn.taketoday.expression.MethodNotFoundException;
import cn.taketoday.expression.PropertyNotWritableException;
import cn.taketoday.expression.ValueExpression;
import cn.taketoday.expression.ValueReference;
import cn.taketoday.expression.VariableMapper;
import cn.taketoday.expression.lang.EvaluationContext;
import cn.taketoday.expression.parser.SimpleNode;

public final class AstIdentifier
extends SimpleNode {
    public AstIdentifier(int id) {
        super(id);
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) {
        ValueExpression expr;
        String image = this.image;
        if (ctx.isLambdaArgument(image)) {
            return Object.class;
        }
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper != null && (expr = varMapper.resolveVariable(image)) != null) {
            return expr.getType(ctx);
        }
        ctx.setPropertyResolved(false);
        Class<?> ret = ctx.getResolver().getType(ctx, null, image);
        if (!ctx.isPropertyResolved()) {
            ctx.handlePropertyNotResolved(null, image, ctx);
        }
        return ret;
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) {
        ValueExpression expr;
        String image = this.image;
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper != null && (expr = varMapper.resolveVariable(image)) != null) {
            return expr.getValueReference(ctx);
        }
        return new ValueReference(null, image);
    }

    @Override
    public Object getValue(EvaluationContext ctx) {
        String image = this.image;
        if (ctx.isLambdaArgument(image)) {
            return ctx.getLambdaArgument(image);
        }
        ValueExpression expr = ctx.getVariableMapper().resolveVariable(image);
        if (expr != null) {
            return expr.getValue(ctx);
        }
        ctx.setPropertyResolved(false);
        Object ret = ctx.getResolver().getValue(ctx, null, image);
        if (!ctx.isPropertyResolved()) {
            Class<?> c;
            ImportHandler importHandler = ctx.getImportHandler();
            if (importHandler != null && (c = importHandler.resolveStatic(image)) != null) {
                return ctx.getResolver().getValue(ctx, c, image);
            }
            ctx.handlePropertyNotResolved(null, image, ctx);
        }
        return ret;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) {
        ValueExpression expr;
        String image = this.image;
        if (ctx.isLambdaArgument(image)) {
            return true;
        }
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper != null && (expr = varMapper.resolveVariable(image)) != null) {
            return expr.isReadOnly(ctx);
        }
        ctx.setPropertyResolved(false);
        boolean ret = ctx.getResolver().isReadOnly(ctx, null, image);
        if (!ctx.isPropertyResolved()) {
            ctx.handlePropertyNotResolved(null, image, ctx);
        }
        return ret;
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) {
        ValueExpression expr;
        String image = this.image;
        if (ctx.isLambdaArgument(image)) {
            throw new PropertyNotWritableException("The Lambda parameter ''" + image + "'' is not writable");
        }
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper != null && (expr = varMapper.resolveVariable(image)) != null) {
            expr.setValue(ctx, value);
            return;
        }
        ctx.setPropertyResolved(false);
        ctx.getResolver().setValue(ctx, null, image, value);
        if (!ctx.isPropertyResolved()) {
            ctx.handlePropertyNotResolved(null, image, ctx);
        }
    }

    @Override
    public Object invoke(EvaluationContext ctx, Class<?>[] paramTypes, Object[] paramValues) {
        return this.getMethodExpression(ctx).invoke(ctx, paramValues);
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class<?>[] paramTypes) {
        return this.getMethodExpression(ctx).getMethodInfo(ctx);
    }

    protected MethodExpression getMethodExpression(EvaluationContext ctx) {
        Object obj = null;
        String image = this.image;
        VariableMapper varMapper = ctx.getVariableMapper();
        ValueExpression ve = null;
        if (varMapper != null && (ve = varMapper.resolveVariable(image)) != null) {
            obj = ve.getValue(ctx);
        }
        if (ve == null) {
            ctx.setPropertyResolved(false);
            obj = ctx.getResolver().getValue(ctx, null, image);
        }
        if (obj instanceof MethodExpression) {
            return (MethodExpression)obj;
        }
        if (obj == null) {
            throw new MethodNotFoundException("Identity '" + image + "' was null and was unable to invoke");
        }
        throw new ExpressionException("Identity '" + image + "' does not reference a MethodExpression instance, returned type: " + obj.getClass().getName());
    }
}

