/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.parser;

import cn.taketoday.context.reflect.MethodInvoker;
import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.ImportHandler;
import cn.taketoday.expression.MethodInfo;
import cn.taketoday.expression.PropertyNotFoundException;
import cn.taketoday.expression.PropertyNotWritableException;
import cn.taketoday.expression.ValueReference;
import cn.taketoday.expression.lang.EvaluationContext;
import cn.taketoday.expression.lang.ExpressionUtils;
import cn.taketoday.expression.parser.AstBracketSuffix;
import cn.taketoday.expression.parser.AstDotSuffix;
import cn.taketoday.expression.parser.AstIdentifier;
import cn.taketoday.expression.parser.AstMethodArguments;
import cn.taketoday.expression.parser.Node;
import cn.taketoday.expression.parser.SimpleNode;
import cn.taketoday.expression.util.ReflectionUtil;
import java.lang.reflect.Method;

public final class AstValue
extends SimpleNode {
    private MethodInvoker targetInvoker;

    public AstValue(int id) {
        super(id);
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ExpressionException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            return null;
        }
        Object property = t.suffixNode.getValue(ctx);
        ctx.setPropertyResolved(false);
        Class<?> ret = ctx.getResolver().getType(ctx, t.base, property);
        if (!ctx.isPropertyResolved()) {
            ctx.handlePropertyNotResolved(t.base, this.image, ctx);
        }
        return ret;
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) throws ExpressionException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            return null;
        }
        Object property = t.suffixNode.getValue(ctx);
        return new ValueReference(t.base, property);
    }

    private static AstMethodArguments getArguments(Node n) {
        if (n instanceof AstDotSuffix && n.jjtGetNumChildren() > 0) {
            return (AstMethodArguments)n.jjtGetChild(0);
        }
        if (n instanceof AstBracketSuffix && n.jjtGetNumChildren() > 1) {
            return (AstMethodArguments)n.jjtGetChild(1);
        }
        return null;
    }

    private Object getValue(Object base, Node child, EvaluationContext ctx) throws ExpressionException {
        ExpressionResolver resolver = ctx.getResolver();
        Object property = child.getValue(ctx);
        AstMethodArguments args = AstValue.getArguments(child);
        if (args != null) {
            if (property instanceof String) {
                ctx.setPropertyResolved(false);
                return resolver.invoke(ctx, base, property, args.getParamTypes(), args.getParameters(ctx));
            }
            throw new ExpressionException("An instance of " + property + " is specified as the static method name, it must be a String");
        }
        Object value = null;
        if (property != null) {
            Object resolved;
            ctx.setPropertyResolved(false);
            value = resolver.getValue(ctx, base, property);
            if (!ctx.isPropertyResolved() && (resolved = ctx.handlePropertyNotResolved(base, this.image, ctx)) != null) {
                return resolved;
            }
        }
        return value;
    }

    private Object getBase(EvaluationContext ctx) {
        Node child = this.children[0];
        try {
            return child.getValue(ctx);
        }
        catch (PropertyNotFoundException ex) {
            if (child instanceof AstIdentifier) {
                Class<?> c;
                String name = ((AstIdentifier)child).image;
                ImportHandler importHandler = ctx.getImportHandler();
                if (importHandler != null && (c = importHandler.resolveClass(name)) != null) {
                    return c;
                }
            }
            throw ex;
        }
    }

    private Target getTarget(EvaluationContext ctx) throws ExpressionException {
        Object base = this.getBase(ctx);
        if (base == null) {
            throw new PropertyNotFoundException("Target Unreachable, identifier ''" + this.children[0].getImage() + "'' resolved to null");
        }
        int propCount = this.jjtGetNumChildren() - 1;
        Node[] children = this.children;
        if (propCount > 1) {
            for (int i = 1; base != null && i < propCount; ++i) {
                base = this.getValue(base, children[i], ctx);
            }
            if (base == null) {
                throw new PropertyNotFoundException("Target Unreachable, returned null");
            }
        }
        return new Target(base, children[propCount]);
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ExpressionException {
        Object base = this.getBase(ctx);
        int propCount = this.jjtGetNumChildren();
        Node[] children = this.children;
        for (int i = 1; base != null && i < propCount; ++i) {
            base = this.getValue(base, children[i], ctx);
        }
        return base;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) throws ExpressionException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            return true;
        }
        Object property = t.suffixNode.getValue(ctx);
        ctx.setPropertyResolved(false);
        boolean ret = ctx.getResolver().isReadOnly(ctx, t.base, property);
        if (!ctx.isPropertyResolved()) {
            ctx.handlePropertyNotResolved(t.base, this.image, ctx);
        }
        return ret;
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) throws ExpressionException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            throw new PropertyNotWritableException("Illegal Syntax for Set Operation");
        }
        Object property = t.suffixNode.getValue(ctx);
        ExpressionResolver elResolver = ctx.getResolver();
        ctx.setPropertyResolved(false);
        Class<?> targetType = elResolver.getType(ctx, t.base, property);
        if (ctx.isPropertyResolved()) {
            ctx.setPropertyResolved(false);
            Object targetValue = elResolver.convertToType(ctx, value, targetType);
            if (ctx.isPropertyResolved()) {
                value = targetValue;
            } else if (value != null || targetType.isPrimitive()) {
                value = ExpressionUtils.coerceToType(value, targetType);
            }
        }
        ctx.setPropertyResolved(false);
        elResolver.setValue(ctx, t.base, property, value);
        if (!ctx.isPropertyResolved()) {
            ctx.handlePropertyNotResolved(t.base, this.image, ctx);
        }
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class<?>[] paramTypes) throws ExpressionException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            return null;
        }
        Object property = t.suffixNode.getValue(ctx);
        Method m = ReflectionUtil.findMethod(t.base.getClass(), property.toString(), paramTypes, null);
        return new MethodInfo(m.getName(), m.getReturnType(), m.getParameterTypes());
    }

    @Override
    public Object invoke(EvaluationContext ctx, Class<?>[] paramTypes, Object[] paramValues) throws ExpressionException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            AstMethodArguments args = AstValue.getArguments(t.suffixNode);
            paramTypes = args.getParamTypes();
            Object[] params = args.getParameters(ctx);
            String method = (String)t.suffixNode.getValue(ctx);
            ctx.setPropertyResolved(false);
            ExpressionResolver resolver = ctx.getResolver();
            return resolver.invoke(ctx, t.base, method, paramTypes, params);
        }
        MethodInvoker targetInvoker = this.targetInvoker;
        if (targetInvoker == null) {
            Object property = t.suffixNode.getValue(ctx);
            Method method = ReflectionUtil.findMethod(t.base.getClass(), property.toString(), paramTypes, paramValues);
            this.targetInvoker = targetInvoker = MethodInvoker.create(method);
        }
        return ReflectionUtil.invokeMethod((ExpressionContext)ctx, targetInvoker, t.base, paramValues);
    }

    @Override
    public boolean isParametersProvided() {
        return AstValue.getArguments(this.children[this.jjtGetNumChildren() - 1]) != null;
    }

    static class Target {
        public Object base;
        public Node suffixNode;

        Target(Object base, Node suffixNode) {
            this.base = base;
            this.suffixNode = suffixNode;
        }

        boolean isMethodCall() {
            return AstValue.getArguments(this.suffixNode) != null;
        }
    }
}

