/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.parser;

import cn.taketoday.expression.parser.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.tokenImage = tokenImageVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuilder expected = new StringBuilder();
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected.append(this.tokenImage[this.expectedTokenSequences[i][j]]).append(" ");
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(this.eol).append("    ");
        }
        StringBuilder ret = new StringBuilder("Encountered \"");
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                ret.append(" ");
            }
            if (tok.kind == 0) {
                ret.append(this.tokenImage[0]);
                break;
            }
            ret.append(this.add_escapes(tok.image));
            tok = tok.next;
        }
        ret.append("\" at line ").append(this.currentToken.next.beginLine).append(", column ").append(this.currentToken.next.beginColumn);
        ret.append('.').append(this.eol);
        if (this.expectedTokenSequences.length == 1) {
            ret.append("Was expecting:").append(this.eol).append("    ");
        } else {
            ret.append("Was expecting one of:").append(this.eol).append("    ");
        }
        ret.append((CharSequence)expected);
        return ret.toString();
    }

    protected String add_escapes(String str) {
        StringBuilder retval = new StringBuilder();
        int length = str.length();
        block11: for (int i = 0; i < length; ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000".concat(Integer.toString(ch, 16));
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

