/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.jdevelops.events.websocket;

import cn.tannn.jdevelops.events.websocket.config.WebSocketAuthenticationConfigurator;
import cn.tannn.jdevelops.events.websocket.config.WebSocketConfig;
import cn.tannn.jdevelops.events.websocket.core.WebSocketServer;
import cn.tannn.jdevelops.events.websocket.service.VerifyService;
import cn.tannn.jdevelops.events.websocket.service.WebSocketCacheService;
import cn.tannn.jdevelops.events.websocket.service.impl.VerifyServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
public class ImportsConfiguration {
    @Bean
    public WebSocketConfig webSocketConfig() {
        return new WebSocketConfig();
    }

    @Bean
    public WebSocketCacheService webSocketCacheService(WebSocketConfig webSocketConfig) {
        return new WebSocketCacheService(webSocketConfig);
    }

    @Bean
    public WebSocketServer webSocketServer(WebSocketCacheService cacheService) {
        return new WebSocketServer(cacheService);
    }

    @Bean
    @ConditionalOnMissingBean(name={"webSocketAuthenticationConfigurator"})
    public WebSocketAuthenticationConfigurator webSocketAuthenticationConfigurator() {
        return new WebSocketAuthenticationConfigurator();
    }

    @Bean
    @ConditionalOnMissingBean(value={VerifyService.class})
    public VerifyService verifyService(WebSocketConfig webSocketConfig) {
        return new VerifyServiceImpl(webSocketConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServerEndpointExporter.class})
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }
}

