/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.jdevelops.events.websocket;

import cn.tannn.jdevelops.events.websocket.core.WebSocketServer;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SocketController {
    public final WebSocketServer webSocketServer;

    public SocketController(WebSocketServer webSocketServer) {
        this.webSocketServer = webSocketServer;
    }

    @GetMapping(value={"/only"})
    @Operation(summary="\u7ed9\u6307\u5b9a\u7528\u6237\u63a8\u9001\u6d88\u606f")
    @Parameters(value={@Parameter(name="userName", description="\u7528\u6237\u540d", required=true), @Parameter(name="message", description="\u6d88\u606f", required=true)})
    public Object onlyUserSocket(@RequestParam(value="userName") String userName, @RequestParam(value="message") String message) {
        this.webSocketServer.sendInfo(userName, message);
        return "success";
    }

    @GetMapping(value={"/only/async"})
    @Operation(summary="\u7ed9\u6307\u5b9a\u7528\u6237\u63a8\u9001\u6d88\u606f(\u5f02\u6b65)")
    @Parameters(value={@Parameter(name="userName", description="\u7528\u6237\u540d", required=true), @Parameter(name="message", description="\u6d88\u606f", required=true)})
    public Object onlyUserAsyncSocket(@RequestParam(value="userName") String userName, @RequestParam(value="message") String message) {
        this.webSocketServer.sendAsyncInfo(userName, message);
        return "success";
    }

    @Operation(summary="\u7ed9\u6240\u6709\u7528\u6237\u63a8\u9001\u6d88\u606f")
    @Parameter(name="message", description="\u6d88\u606f", required=true)
    @GetMapping(value={"/all"})
    public Object allUserSocket(@RequestParam(value="message") String message) {
        this.webSocketServer.onMessage(message);
        return "success";
    }

    @Operation(summary="\u7ed9\u6240\u6709\u7528\u6237\u63a8\u9001\u6d88\u606f(\u5f02\u6b65)")
    @Parameter(name="message", description="\u6d88\u606f", required=true)
    @GetMapping(value={"/all/async"})
    public Object allUserAsyncSocket(@RequestParam(value="message") String message) {
        this.webSocketServer.onAsyncMessage(message);
        return "success";
    }

    @Operation(summary="\u6a21\u7cca\u5339\u914d\u7528\u6237\u8fdb\u884c\u6d88\u606f\u53d1\u9001")
    @Parameters(value={@Parameter(name="keyPrefix", description="\u7528\u6237\u5173\u952e\u5b57", required=true), @Parameter(name="message", description="\u6d88\u606f", required=true)})
    @GetMapping(value={"/prefix"})
    public Object sendInfoByLikeKey(@RequestParam(value="keyPrefix") String keyPrefix, @RequestParam(value="message") String message) {
        this.webSocketServer.sendInfoByLikeKey(keyPrefix, message);
        return "success";
    }

    @Operation(summary="\u6a21\u7cca\u5339\u914d\u7528\u6237\u8fdb\u884c\u6d88\u606f\u53d1\u9001(\u5f02\u6b65)")
    @Parameters(value={@Parameter(name="keyPrefix", description="\u7528\u6237\u5173\u952e\u5b57", required=true), @Parameter(name="message", description="\u6d88\u606f", required=true)})
    @GetMapping(value={"/prefix/async"})
    public Object sendInfoAsyncByLikeKey(@RequestParam(value="keyPrefix") String keyPrefix, @RequestParam(value="message") String message) {
        this.webSocketServer.sendAsyncInfoByLikeKey(keyPrefix, message);
        return "success";
    }
}

