/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.jdevelops.events.websocket.config;

import cn.tannn.jdevelops.events.websocket.config.WebSocketConfig;
import cn.tannn.jdevelops.events.websocket.service.VerifyService;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebSocketAuthenticationConfigurator
extends ServerEndpointConfig.Configurator
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        WebSocketAuthenticationConfigurator.applicationContext = applicationContext;
    }

    public <T> T getEndpointInstance(Class<T> clazz) {
        return (T)applicationContext.getBean(clazz);
    }

    public boolean checkOrigin(String originHeaderValue) {
        WebSocketConfig webSocketConfig;
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (servletRequestAttributes != null);
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String servletPath = request.getServletPath();
        VerifyService verifyService = (VerifyService)applicationContext.getBean(VerifyService.class);
        if (verifyService.verifyPath(servletPath, (webSocketConfig = (WebSocketConfig)applicationContext.getBean(WebSocketConfig.class)).isVerifyPathNo())) {
            return verifyService.verifyLogin(request);
        }
        return false;
    }
}

