/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.jdevelops.events.websocket.core;

import cn.tannn.jdevelops.events.websocket.config.WebSocketAuthenticationConfigurator;
import cn.tannn.jdevelops.events.websocket.core.CommonConstant;
import cn.tannn.jdevelops.events.websocket.service.WebSocketCacheService;
import cn.tannn.jdevelops.events.websocket.util.SocketUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(value={WebSocketServer.class})
@ServerEndpoint(value="/socket/{ver}/{name}", configurator=WebSocketAuthenticationConfigurator.class)
public class WebSocketServer {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServer.class);
    public final WebSocketCacheService cacheService;
    private static AtomicInteger online = new AtomicInteger(0);

    public WebSocketServer(WebSocketCacheService cacheService) {
        this.cacheService = cacheService;
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="name") String userName, @PathParam(value="ver") String verify) {
        if (!CommonConstant.OK_PATH.contains(verify)) {
            logger.error("\u7b2c\u4e8c\u8def\u5f84\u4e0d\u5408\u6cd5\uff0c\u7b2c\u4e8c\u8def\u5f84\u53ea\u80fd\u4e3a\uff1ay,n");
            return;
        }
        Session onCloseSession = this.cacheService.saveSession(userName, verify, session);
        if (Objects.nonNull(onCloseSession)) {
            this.onClose(userName, verify, onCloseSession);
        }
        WebSocketServer.addOnlineCount();
        logger.info("{}\u52a0\u5165webSocket\uff01\u5f53\u524d\u4eba\u6570\u4e3a{}", (Object)userName, (Object)online);
        this.sendMessage(session, "\u6b22\u8fce" + userName + "\u52a0\u5165\u8fde\u63a5\uff01");
    }

    @OnClose
    public void onClose(@PathParam(value="name") String userName, @PathParam(value="ver") String verify, Session session) {
        this.sendMessage(session, "\u60a8\u5df2\u88ab\u65ad\u5f00\u4e86\u8fde\u63a5\uff01");
        this.cacheService.removeSession(userName, verify, session);
        try {
            if (Objects.nonNull(session)) {
                session.close();
            }
        }
        catch (IOException e) {
            logger.error("session\u5173\u95ed\u5f02\u5e38", (Throwable)e);
        }
        WebSocketServer.subOnlineCount();
        logger.info("{}\u65ad\u5f00webSocket\u8fde\u63a5\uff01\u5f53\u524d\u4eba\u6570\u4e3a{}", (Object)userName, (Object)online);
    }

    @OnMessage
    public void onMessage(String message) {
        for (Session session : this.cacheService.loadSession()) {
            try {
                this.sendMessage(session, message);
            }
            catch (Exception e) {
                logger.error("\u7fa4\u53d1\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @OnMessage
    public void onMessage(byte[] message) {
        for (Session session : this.cacheService.loadSession()) {
            try {
                this.sendMessage(session, message);
            }
            catch (Exception e) {
                logger.error("\u7fa4\u53d1\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void onAsyncMessage(String message) {
        for (Session session : this.cacheService.loadSession()) {
            try {
                this.sendAsyncMessage(session, message);
            }
            catch (Exception e) {
                logger.error("\u7fa4\u53d1\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @OnError
    public void onError(Throwable throwable) {
        logger.error("websocket\u53d1\u751f\u9519\u8bef", throwable);
    }

    public void sendInfo(String userName, String message) {
        List<Session> sessions = this.cacheService.loadSession(userName);
        if (sessions != null) {
            try {
                sessions.forEach(session -> this.sendMessage((Session)session, message));
            }
            catch (Exception e) {
                logger.error("\u6307\u5b9a\u7528\u6237\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void sendAsyncInfo(String userName, String message) {
        List<Session> sessions = this.cacheService.loadSession(userName);
        if (sessions != null) {
            try {
                sessions.forEach(session -> this.sendAsyncMessage((Session)session, message));
            }
            catch (Exception e) {
                logger.error("\u6307\u5b9a\u7528\u6237\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void sendInfoByLikeKey(String userName, String message) {
        Map<String, List<Session>> stringListMap = SocketUtil.parseMapForFilter(this.cacheService.loadSessionForPools(), userName);
        ArrayList session = new ArrayList();
        stringListMap.forEach((key, value) -> session.addAll(value));
        try {
            session.forEach(se -> this.sendMessage((Session)se, message));
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void sendAsyncInfoByLikeKey(String userName, String message) {
        Map<String, List<Session>> stringListMap = SocketUtil.parseMapForFilter(this.cacheService.loadSessionForPools(), userName);
        ArrayList session = new ArrayList();
        stringListMap.forEach((key, value) -> session.addAll(value));
        try {
            session.forEach(se -> this.sendAsyncMessage((Session)se, message));
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Session session, String message) {
        block7: {
            try {
                if (session == null) break block7;
                ReentrantLock lock = new ReentrantLock();
                lock.lock();
                try {
                    session.getAsyncRemote().sendText(message);
                }
                catch (Exception exception) {
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                logger.warn("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Session session, byte[] message) {
        block7: {
            try {
                if (session == null) break block7;
                ReentrantLock lock = new ReentrantLock();
                lock.lock();
                try {
                    session.getAsyncRemote().sendBinary(ByteBuffer.wrap(message));
                }
                catch (Exception exception) {
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                logger.warn("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void sendAsyncMessage(Session session, String message) {
        try {
            if (session != null) {
                session.getAsyncRemote().sendText(message);
            }
        }
        catch (Exception e) {
            logger.warn("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public static void addOnlineCount() {
        online.incrementAndGet();
    }

    public static void subOnlineCount() {
        if (online.get() > 0) {
            online.decrementAndGet();
        } else {
            online.set(0);
        }
    }
}

