/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.jdevelops.events.websocket.service;

import cn.tannn.jdevelops.events.websocket.cache.SessionInfo;
import cn.tannn.jdevelops.events.websocket.cache.WebSocketSessionLocalCache;
import cn.tannn.jdevelops.events.websocket.config.WebSocketConfig;
import cn.tannn.jdevelops.events.websocket.exception.WebSocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketCacheService {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketCacheService.class);
    public final WebSocketConfig webSocketConfig;

    public WebSocketCacheService(WebSocketConfig webSocketConfig) {
        this.webSocketConfig = webSocketConfig;
    }

    public Session saveSession(String userName, String verify, Session session) {
        Session resultSession = null;
        ArrayList<Session> sessionsArray = new ArrayList<Session>();
        List<Session> sessions = this.loadSession(userName);
        if (this.webSocketConfig.isMultipart()) {
            if (sessions != null) {
                sessionsArray.addAll(sessions);
            }
            sessionsArray.add(session);
            this.saveSession(userName, verify, sessionsArray);
        } else {
            if (sessions == null || sessions.isEmpty()) {
                sessionsArray.add(session);
                this.saveSession(userName, verify, sessionsArray);
            }
            if (this.webSocketConfig.isOnClose()) {
                this.removeSession(userName);
                sessionsArray.add(session);
                this.saveSession(userName, verify, sessionsArray);
                resultSession = sessions == null || sessions.isEmpty() ? null : sessions.get(0);
            } else if (Objects.nonNull(sessions) && !sessions.isEmpty()) {
                resultSession = session;
            }
        }
        return resultSession;
    }

    public void saveSession(String userName, String verify, List<Session> sessionsArray) {
        SessionInfo sessionInfo;
        Map<String, SessionInfo> robustSessionPools = WebSocketSessionLocalCache.ROBUST_SESSION_POOLS;
        if (!(robustSessionPools.isEmpty() || (sessionInfo = WebSocketSessionLocalCache.ROBUST_SESSION_POOLS.get(userName)) == null || sessionInfo.getSessions() == null || sessionInfo.getSessions().isEmpty() || sessionInfo.getPath().equalsIgnoreCase(verify))) {
            throw new WebSocketException("\u540c\u4e00\u4e2a\u7528\u6237\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728\u4e8e Y/N \u8fde\u63a5");
        }
        WebSocketSessionLocalCache.ROBUST_SESSION_POOLS.put(userName, new SessionInfo(sessionsArray, verify));
    }

    public List<Session> loadSession(String userName) {
        SessionInfo sessionInfo = WebSocketSessionLocalCache.ROBUST_SESSION_POOLS.get(userName);
        if (sessionInfo != null) {
            return sessionInfo.getSessions();
        }
        return new ArrayList<Session>();
    }

    public List<Session> loadSession() {
        Collection<SessionInfo> sessionInfos = WebSocketSessionLocalCache.ROBUST_SESSION_POOLS.values();
        ArrayList<Session> result = new ArrayList<Session>();
        for (SessionInfo sessionInfo : sessionInfos) {
            List<Session> sessions = sessionInfo.getSessions();
            if (sessions == null || sessions.isEmpty()) continue;
            result.addAll(sessions);
        }
        return result;
    }

    public Map<String, List<Session>> loadSessionForPools() {
        HashMap<String, List<Session>> result = new HashMap<String, List<Session>>();
        WebSocketSessionLocalCache.ROBUST_SESSION_POOLS.forEach((k, v) -> result.put((String)k, v.getSessions()));
        return result;
    }

    public void removeSession(String userName) {
        WebSocketSessionLocalCache.ROBUST_SESSION_POOLS.remove(userName);
    }

    public void removeSession(String userName, String verify, Session session) {
        if (session == null) {
            this.removeSession(userName);
        } else {
            List<Session> sessions = this.loadSession(userName);
            sessions.remove(session);
            this.saveSession(userName, verify, sessions);
        }
    }
}

