/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.jdevelops.events.websocket.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketUtil {
    private static Logger logger = LoggerFactory.getLogger(SocketUtil.class);

    public static Map<String, List<Session>> parseMapForFilter(Map<String, List<Session>> map, String filters) {
        if (map == null) {
            return Collections.emptyMap();
        }
        map = map.entrySet().stream().filter(e -> SocketUtil.checkKey((String)e.getKey(), filters)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return map;
    }

    private static boolean checkKey(String key, String filters) {
        return key.contains(filters);
    }

    public static boolean banConnection(String socketPath, boolean verifyPathNo) {
        if (!verifyPathNo && socketPath.contains("/socket/n/")) {
            logger.error(socketPath + "\u4e0d\u9700\u8981\u9a8c\u8bc1\u767b\u5f55\u7684socket\u8bf7\u6c42\u88ab\u7981\u6b62\uff0c\u53ea\u5141\u8bb8\"/socket/y/\"");
            return true;
        }
        if (socketPath.contains("/socket/n/") || socketPath.contains("/socket/y/")) {
            return false;
        }
        logger.error(socketPath + "\u8def\u5f84\u4e0d\u5408\u6cd5\uff0c\u53ea\u5141\u8bb8\"/socket/y/\",\"/socket/n/\"");
        return true;
    }
}

