/*
 * Copyright 2024 Taskflow, Inc.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.feiliu.protogen.config;

import lombok.Builder;
import lombok.Getter;

import java.io.File;

/**
 * 基础配置
 *
 * @author SHOUSHEN.LUAN
 * @since 2024-12-17
 */
@Getter
@Builder
public class BaseConfig {
    /*跟路径*/
    private String root;
    /*子模块名称*/
    private String submodule;
    /**
     * 输出目录:
     * <li>src/main/proto</li>
     * <li>src/test/proto</li>
     */
    private String protoDirectory;
    /**
     * 输出目录:
     * <li>src/main/java</li>
     * <li>src/test/java</li>
     */
    private String outputJavaDirectory;

    public File getRootDirectory() {
        File file;
        if (root != null) {
            if (submodule != null) {
                file = new File(root, submodule);
            } else {
                file = new File(root);
            }
        } else {
            String root = System.getProperty("user.dir") + "/";
            if (submodule != null) {
                file = new File(root, submodule);
            } else {
                file = new File(root);
            }
        }
        return file;
    }

    public File getProtoSourceRootFile() {
        return new File(getRootDirectory(), protoDirectory);
    }

    public File getOutputDirectoryFile() {
        return new File(getRootDirectory(), outputJavaDirectory);
    }

}
