/*
 * Copyright 2024 Taskflow, Inc.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.feiliu.protogen.proto;

import lombok.Getter;

import java.io.File;

/**
 * @author SHOUSHEN.LUAN
 * @since 2024-12-17
 */
@Getter
public class ProtoGenConfig {
    /*proto在项目中存储路径*/
    String protoPath;
    /*proto 生成Java文件的包路径*/
    String javaPackage;
    /*proto 生成go文件的包路径*/
    String goPackage;
    /*源文件的包路径*/
    String sourcePackage;
    /*生成对象转换Mapper类的包路径*/
    String mapperPackage;
    /*定义从jar文件中寻找 需要处理的POJO类*/
    File   jarFile;

    public boolean isFromJarFile() {
        return jarFile != null;
    }

    public ProtoGenConfig withProtoPath(String protoPath) {
        this.protoPath = protoPath;
        return this;
    }

    public ProtoGenConfig withJavaPackage(String javaPackage) {
        this.javaPackage = javaPackage;
        return this;
    }

    public ProtoGenConfig withGoPackage(String goPackage) {
        this.goPackage = goPackage;
        return this;
    }

    public ProtoGenConfig withSourcePackage(String sourcePackage) {
        this.sourcePackage = sourcePackage;
        return this;
    }

    public ProtoGenConfig withMapperPackage(String mapperPackage) {
        this.mapperPackage = mapperPackage;
        return this;
    }

    public ProtoGenConfig withJarFile(File jarFile) {
        this.jarFile = jarFile;
        return this;
    }
}
