/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.constraints;

import cn.feiliu.taskflow.common.utils.Validator;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang3.StringUtils;

@Documented
@Constraint(validatedBy={WorkflowTaskValidValidator.class})
@Target(value={ElementType.TYPE, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface EmailConstraint {
    public String message() default "{cn.feiliu.taskflow.common.constraints.EmailConstraint.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class WorkflowTaskValidValidator
    implements ConstraintValidator<EmailConstraint, String> {
        public void initialize(EmailConstraint constraintAnnotation) {
        }

        public boolean isValid(String ownerEmail, ConstraintValidatorContext context) {
            if (StringUtils.isNotBlank((CharSequence)ownerEmail)) {
                return Validator.isEmail(ownerEmail);
            }
            return true;
        }
    }
}

