/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.constraints;

import cn.feiliu.taskflow.common.metadata.workflow.WorkflowDefinition;
import cn.feiliu.taskflow.common.utils.Validator;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Documented
@Constraint(validatedBy={TaskReferenceNameUniqueValidator.class})
@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface TaskReferenceNameUniqueConstraint {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class TaskReferenceNameUniqueValidator
    implements ConstraintValidator<TaskReferenceNameUniqueConstraint, WorkflowDefinition> {
        public void initialize(TaskReferenceNameUniqueConstraint constraintAnnotation) {
        }

        public boolean isValid(WorkflowDefinition workflowDef, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            List<String> errors = Validator.verifyWorkflowDef(workflowDef);
            errors.forEach(message -> context.buildConstraintViolationWithTemplate(message).addConstraintViolation());
            return errors.isEmpty();
        }
    }
}

