/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.metadata.tasks;

import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import com.google.protobuf.Any;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ExecutingTask {
    private String taskType;
    private Status status;
    private Map<String, Object> inputData = new HashMap<String, Object>();
    private String referenceTaskName;
    private int retryCount;
    private int seq;
    private String correlationId;
    private int pollCount;
    private String taskDefName;
    private long scheduledTime;
    private long startTime;
    private long endTime;
    private long updateTime;
    private int startDelayInSeconds;
    private String retriedTaskId;
    private boolean retried;
    private boolean executed;
    private boolean callbackFromWorker = true;
    private long responseTimeoutSeconds;
    private String workflowInstanceId;
    private String workflowType;
    private String taskId;
    private String reasonForIncompletion;
    private long callbackAfterSeconds;
    private String workerId;
    private Map<String, Object> outputData = new HashMap<String, Object>();
    private FlowTask workflowTask;
    private String domain;
    private Any inputMessage;
    private Any outputMessage;
    private int rateLimitPerFrequency;
    private int rateLimitFrequencyInSeconds;
    private String externalInputPayloadStoragePath;
    private String externalOutputPayloadStoragePath;
    private int workflowPriority;
    private String executionNameSpace;
    private String isolationGroupId;
    private int iteration;
    private String subWorkflowId;
    private boolean subworkflowChanged;

    public long getQueueWaitTime() {
        if (this.startTime > 0L && this.scheduledTime > 0L) {
            if (this.updateTime > 0L && this.getCallbackAfterSeconds() > 0L) {
                long waitTime = System.currentTimeMillis() - (this.updateTime + this.getCallbackAfterSeconds() * 1000L);
                return waitTime > 0L ? waitTime : 0L;
            }
            return this.startTime - this.scheduledTime;
        }
        return 0L;
    }

    public String getTaskDefName() {
        if (this.taskDefName == null || "".equals(this.taskDefName)) {
            this.taskDefName = this.taskType;
        }
        return this.taskDefName;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = StringUtils.substring((String)reasonForIncompletion, (int)0, (int)500);
    }

    public boolean isLoopOverTask() {
        return this.iteration > 0;
    }

    public String getSubWorkflowId() {
        if (StringUtils.isNotBlank((CharSequence)this.subWorkflowId)) {
            return this.subWorkflowId;
        }
        return this.getOutputData() != null && this.getOutputData().get("subWorkflowId") != null ? (String)this.getOutputData().get("subWorkflowId") : (this.getInputData() != null ? (String)this.getInputData().get("subWorkflowId") : null);
    }

    public void setSubWorkflowId(String subWorkflowId) {
        this.subWorkflowId = subWorkflowId;
        if (this.getOutputData() != null && this.getOutputData().containsKey("subWorkflowId")) {
            this.getOutputData().put("subWorkflowId", subWorkflowId);
        }
    }

    public ExecutingTask copy() {
        ExecutingTask copy = new ExecutingTask();
        copy.setCallbackAfterSeconds(this.callbackAfterSeconds);
        copy.setCallbackFromWorker(this.callbackFromWorker);
        copy.setCorrelationId(this.correlationId);
        copy.setInputData(this.inputData);
        copy.setOutputData(this.outputData);
        copy.setReferenceTaskName(this.referenceTaskName);
        copy.setStartDelayInSeconds(this.startDelayInSeconds);
        copy.setTaskDefName(this.taskDefName);
        copy.setTaskType(this.taskType);
        copy.setWorkflowInstanceId(this.workflowInstanceId);
        copy.setWorkflowType(this.workflowType);
        copy.setResponseTimeoutSeconds(this.responseTimeoutSeconds);
        copy.setStatus(this.status);
        copy.setRetryCount(this.retryCount);
        copy.setPollCount(this.pollCount);
        copy.setTaskId(this.taskId);
        copy.setWorkflowTask(this.workflowTask);
        copy.setDomain(this.domain);
        copy.setInputMessage(this.inputMessage);
        copy.setOutputMessage(this.outputMessage);
        copy.setRateLimitPerFrequency(this.rateLimitPerFrequency);
        copy.setRateLimitFrequencyInSeconds(this.rateLimitFrequencyInSeconds);
        copy.setExternalInputPayloadStoragePath(this.externalInputPayloadStoragePath);
        copy.setExternalOutputPayloadStoragePath(this.externalOutputPayloadStoragePath);
        copy.setWorkflowPriority(this.workflowPriority);
        copy.setIteration(this.iteration);
        copy.setExecutionNameSpace(this.executionNameSpace);
        copy.setIsolationGroupId(this.isolationGroupId);
        copy.setSubWorkflowId(this.getSubWorkflowId());
        copy.setSubworkflowChanged(this.subworkflowChanged);
        return copy;
    }

    public ExecutingTask deepCopy() {
        ExecutingTask deepCopy = this.copy();
        deepCopy.setStartTime(this.startTime);
        deepCopy.setScheduledTime(this.scheduledTime);
        deepCopy.setEndTime(this.endTime);
        deepCopy.setWorkerId(this.workerId);
        deepCopy.setReasonForIncompletion(this.reasonForIncompletion);
        deepCopy.setSeq(this.seq);
        return deepCopy;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public Status getStatus() {
        return this.status;
    }

    public Map<String, Object> getInputData() {
        return this.inputData;
    }

    public String getReferenceTaskName() {
        return this.referenceTaskName;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getSeq() {
        return this.seq;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public int getPollCount() {
        return this.pollCount;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public int getStartDelayInSeconds() {
        return this.startDelayInSeconds;
    }

    public String getRetriedTaskId() {
        return this.retriedTaskId;
    }

    public boolean isRetried() {
        return this.retried;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public boolean isCallbackFromWorker() {
        return this.callbackFromWorker;
    }

    public long getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public long getCallbackAfterSeconds() {
        return this.callbackAfterSeconds;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public FlowTask getWorkflowTask() {
        return this.workflowTask;
    }

    public String getDomain() {
        return this.domain;
    }

    public Any getInputMessage() {
        return this.inputMessage;
    }

    public Any getOutputMessage() {
        return this.outputMessage;
    }

    public int getRateLimitPerFrequency() {
        return this.rateLimitPerFrequency;
    }

    public int getRateLimitFrequencyInSeconds() {
        return this.rateLimitFrequencyInSeconds;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public int getWorkflowPriority() {
        return this.workflowPriority;
    }

    public String getExecutionNameSpace() {
        return this.executionNameSpace;
    }

    public String getIsolationGroupId() {
        return this.isolationGroupId;
    }

    public int getIteration() {
        return this.iteration;
    }

    public boolean isSubworkflowChanged() {
        return this.subworkflowChanged;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setInputData(Map<String, Object> inputData) {
        this.inputData = inputData;
    }

    public void setReferenceTaskName(String referenceTaskName) {
        this.referenceTaskName = referenceTaskName;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setPollCount(int pollCount) {
        this.pollCount = pollCount;
    }

    public void setTaskDefName(String taskDefName) {
        this.taskDefName = taskDefName;
    }

    public void setScheduledTime(long scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setStartDelayInSeconds(int startDelayInSeconds) {
        this.startDelayInSeconds = startDelayInSeconds;
    }

    public void setRetriedTaskId(String retriedTaskId) {
        this.retriedTaskId = retriedTaskId;
    }

    public void setRetried(boolean retried) {
        this.retried = retried;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public void setCallbackFromWorker(boolean callbackFromWorker) {
        this.callbackFromWorker = callbackFromWorker;
    }

    public void setResponseTimeoutSeconds(long responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public void setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setCallbackAfterSeconds(long callbackAfterSeconds) {
        this.callbackAfterSeconds = callbackAfterSeconds;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public void setWorkflowTask(FlowTask workflowTask) {
        this.workflowTask = workflowTask;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setInputMessage(Any inputMessage) {
        this.inputMessage = inputMessage;
    }

    public void setOutputMessage(Any outputMessage) {
        this.outputMessage = outputMessage;
    }

    public void setRateLimitPerFrequency(int rateLimitPerFrequency) {
        this.rateLimitPerFrequency = rateLimitPerFrequency;
    }

    public void setRateLimitFrequencyInSeconds(int rateLimitFrequencyInSeconds) {
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public void setWorkflowPriority(int workflowPriority) {
        this.workflowPriority = workflowPriority;
    }

    public void setExecutionNameSpace(String executionNameSpace) {
        this.executionNameSpace = executionNameSpace;
    }

    public void setIsolationGroupId(String isolationGroupId) {
        this.isolationGroupId = isolationGroupId;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void setSubworkflowChanged(boolean subworkflowChanged) {
        this.subworkflowChanged = subworkflowChanged;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutingTask)) {
            return false;
        }
        ExecutingTask other = (ExecutingTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRetryCount() != other.getRetryCount()) {
            return false;
        }
        if (this.getSeq() != other.getSeq()) {
            return false;
        }
        if (this.getPollCount() != other.getPollCount()) {
            return false;
        }
        if (this.getScheduledTime() != other.getScheduledTime()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        if (this.getUpdateTime() != other.getUpdateTime()) {
            return false;
        }
        if (this.getStartDelayInSeconds() != other.getStartDelayInSeconds()) {
            return false;
        }
        if (this.isRetried() != other.isRetried()) {
            return false;
        }
        if (this.isExecuted() != other.isExecuted()) {
            return false;
        }
        if (this.isCallbackFromWorker() != other.isCallbackFromWorker()) {
            return false;
        }
        if (this.getResponseTimeoutSeconds() != other.getResponseTimeoutSeconds()) {
            return false;
        }
        if (this.getCallbackAfterSeconds() != other.getCallbackAfterSeconds()) {
            return false;
        }
        if (this.getRateLimitPerFrequency() != other.getRateLimitPerFrequency()) {
            return false;
        }
        if (this.getRateLimitFrequencyInSeconds() != other.getRateLimitFrequencyInSeconds()) {
            return false;
        }
        if (this.getWorkflowPriority() != other.getWorkflowPriority()) {
            return false;
        }
        if (this.getIteration() != other.getIteration()) {
            return false;
        }
        if (this.isSubworkflowChanged() != other.isSubworkflowChanged()) {
            return false;
        }
        String this$taskType = this.getTaskType();
        String other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Map<String, Object> this$inputData = this.getInputData();
        Map<String, Object> other$inputData = other.getInputData();
        if (this$inputData == null ? other$inputData != null : !((Object)this$inputData).equals(other$inputData)) {
            return false;
        }
        String this$referenceTaskName = this.getReferenceTaskName();
        String other$referenceTaskName = other.getReferenceTaskName();
        if (this$referenceTaskName == null ? other$referenceTaskName != null : !this$referenceTaskName.equals(other$referenceTaskName)) {
            return false;
        }
        String this$correlationId = this.getCorrelationId();
        String other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        String this$taskDefName = this.getTaskDefName();
        String other$taskDefName = other.getTaskDefName();
        if (this$taskDefName == null ? other$taskDefName != null : !this$taskDefName.equals(other$taskDefName)) {
            return false;
        }
        String this$retriedTaskId = this.getRetriedTaskId();
        String other$retriedTaskId = other.getRetriedTaskId();
        if (this$retriedTaskId == null ? other$retriedTaskId != null : !this$retriedTaskId.equals(other$retriedTaskId)) {
            return false;
        }
        String this$workflowInstanceId = this.getWorkflowInstanceId();
        String other$workflowInstanceId = other.getWorkflowInstanceId();
        if (this$workflowInstanceId == null ? other$workflowInstanceId != null : !this$workflowInstanceId.equals(other$workflowInstanceId)) {
            return false;
        }
        String this$workflowType = this.getWorkflowType();
        String other$workflowType = other.getWorkflowType();
        if (this$workflowType == null ? other$workflowType != null : !this$workflowType.equals(other$workflowType)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$reasonForIncompletion = this.getReasonForIncompletion();
        String other$reasonForIncompletion = other.getReasonForIncompletion();
        if (this$reasonForIncompletion == null ? other$reasonForIncompletion != null : !this$reasonForIncompletion.equals(other$reasonForIncompletion)) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        Map<String, Object> this$outputData = this.getOutputData();
        Map<String, Object> other$outputData = other.getOutputData();
        if (this$outputData == null ? other$outputData != null : !((Object)this$outputData).equals(other$outputData)) {
            return false;
        }
        FlowTask this$workflowTask = this.getWorkflowTask();
        FlowTask other$workflowTask = other.getWorkflowTask();
        if (this$workflowTask == null ? other$workflowTask != null : !((Object)this$workflowTask).equals(other$workflowTask)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        Any this$inputMessage = this.getInputMessage();
        Any other$inputMessage = other.getInputMessage();
        if (this$inputMessage == null ? other$inputMessage != null : !this$inputMessage.equals(other$inputMessage)) {
            return false;
        }
        Any this$outputMessage = this.getOutputMessage();
        Any other$outputMessage = other.getOutputMessage();
        if (this$outputMessage == null ? other$outputMessage != null : !this$outputMessage.equals(other$outputMessage)) {
            return false;
        }
        String this$externalInputPayloadStoragePath = this.getExternalInputPayloadStoragePath();
        String other$externalInputPayloadStoragePath = other.getExternalInputPayloadStoragePath();
        if (this$externalInputPayloadStoragePath == null ? other$externalInputPayloadStoragePath != null : !this$externalInputPayloadStoragePath.equals(other$externalInputPayloadStoragePath)) {
            return false;
        }
        String this$externalOutputPayloadStoragePath = this.getExternalOutputPayloadStoragePath();
        String other$externalOutputPayloadStoragePath = other.getExternalOutputPayloadStoragePath();
        if (this$externalOutputPayloadStoragePath == null ? other$externalOutputPayloadStoragePath != null : !this$externalOutputPayloadStoragePath.equals(other$externalOutputPayloadStoragePath)) {
            return false;
        }
        String this$executionNameSpace = this.getExecutionNameSpace();
        String other$executionNameSpace = other.getExecutionNameSpace();
        if (this$executionNameSpace == null ? other$executionNameSpace != null : !this$executionNameSpace.equals(other$executionNameSpace)) {
            return false;
        }
        String this$isolationGroupId = this.getIsolationGroupId();
        String other$isolationGroupId = other.getIsolationGroupId();
        if (this$isolationGroupId == null ? other$isolationGroupId != null : !this$isolationGroupId.equals(other$isolationGroupId)) {
            return false;
        }
        String this$subWorkflowId = this.getSubWorkflowId();
        String other$subWorkflowId = other.getSubWorkflowId();
        return !(this$subWorkflowId == null ? other$subWorkflowId != null : !this$subWorkflowId.equals(other$subWorkflowId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutingTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetryCount();
        result = result * 59 + this.getSeq();
        result = result * 59 + this.getPollCount();
        long $scheduledTime = this.getScheduledTime();
        result = result * 59 + (int)($scheduledTime >>> 32 ^ $scheduledTime);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
        result = result * 59 + this.getStartDelayInSeconds();
        result = result * 59 + (this.isRetried() ? 79 : 97);
        result = result * 59 + (this.isExecuted() ? 79 : 97);
        result = result * 59 + (this.isCallbackFromWorker() ? 79 : 97);
        long $responseTimeoutSeconds = this.getResponseTimeoutSeconds();
        result = result * 59 + (int)($responseTimeoutSeconds >>> 32 ^ $responseTimeoutSeconds);
        long $callbackAfterSeconds = this.getCallbackAfterSeconds();
        result = result * 59 + (int)($callbackAfterSeconds >>> 32 ^ $callbackAfterSeconds);
        result = result * 59 + this.getRateLimitPerFrequency();
        result = result * 59 + this.getRateLimitFrequencyInSeconds();
        result = result * 59 + this.getWorkflowPriority();
        result = result * 59 + this.getIteration();
        result = result * 59 + (this.isSubworkflowChanged() ? 79 : 97);
        String $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Map<String, Object> $inputData = this.getInputData();
        result = result * 59 + ($inputData == null ? 43 : ((Object)$inputData).hashCode());
        String $referenceTaskName = this.getReferenceTaskName();
        result = result * 59 + ($referenceTaskName == null ? 43 : $referenceTaskName.hashCode());
        String $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        String $taskDefName = this.getTaskDefName();
        result = result * 59 + ($taskDefName == null ? 43 : $taskDefName.hashCode());
        String $retriedTaskId = this.getRetriedTaskId();
        result = result * 59 + ($retriedTaskId == null ? 43 : $retriedTaskId.hashCode());
        String $workflowInstanceId = this.getWorkflowInstanceId();
        result = result * 59 + ($workflowInstanceId == null ? 43 : $workflowInstanceId.hashCode());
        String $workflowType = this.getWorkflowType();
        result = result * 59 + ($workflowType == null ? 43 : $workflowType.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $reasonForIncompletion = this.getReasonForIncompletion();
        result = result * 59 + ($reasonForIncompletion == null ? 43 : $reasonForIncompletion.hashCode());
        String $workerId = this.getWorkerId();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        Map<String, Object> $outputData = this.getOutputData();
        result = result * 59 + ($outputData == null ? 43 : ((Object)$outputData).hashCode());
        FlowTask $workflowTask = this.getWorkflowTask();
        result = result * 59 + ($workflowTask == null ? 43 : ((Object)$workflowTask).hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        Any $inputMessage = this.getInputMessage();
        result = result * 59 + ($inputMessage == null ? 43 : $inputMessage.hashCode());
        Any $outputMessage = this.getOutputMessage();
        result = result * 59 + ($outputMessage == null ? 43 : $outputMessage.hashCode());
        String $externalInputPayloadStoragePath = this.getExternalInputPayloadStoragePath();
        result = result * 59 + ($externalInputPayloadStoragePath == null ? 43 : $externalInputPayloadStoragePath.hashCode());
        String $externalOutputPayloadStoragePath = this.getExternalOutputPayloadStoragePath();
        result = result * 59 + ($externalOutputPayloadStoragePath == null ? 43 : $externalOutputPayloadStoragePath.hashCode());
        String $executionNameSpace = this.getExecutionNameSpace();
        result = result * 59 + ($executionNameSpace == null ? 43 : $executionNameSpace.hashCode());
        String $isolationGroupId = this.getIsolationGroupId();
        result = result * 59 + ($isolationGroupId == null ? 43 : $isolationGroupId.hashCode());
        String $subWorkflowId = this.getSubWorkflowId();
        result = result * 59 + ($subWorkflowId == null ? 43 : $subWorkflowId.hashCode());
        return result;
    }

    public String toString() {
        return "ExecutingTask(taskType=" + this.getTaskType() + ", status=" + this.getStatus() + ", inputData=" + this.getInputData() + ", referenceTaskName=" + this.getReferenceTaskName() + ", retryCount=" + this.getRetryCount() + ", seq=" + this.getSeq() + ", correlationId=" + this.getCorrelationId() + ", pollCount=" + this.getPollCount() + ", taskDefName=" + this.getTaskDefName() + ", scheduledTime=" + this.getScheduledTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", updateTime=" + this.getUpdateTime() + ", startDelayInSeconds=" + this.getStartDelayInSeconds() + ", retriedTaskId=" + this.getRetriedTaskId() + ", retried=" + this.isRetried() + ", executed=" + this.isExecuted() + ", callbackFromWorker=" + this.isCallbackFromWorker() + ", responseTimeoutSeconds=" + this.getResponseTimeoutSeconds() + ", workflowInstanceId=" + this.getWorkflowInstanceId() + ", workflowType=" + this.getWorkflowType() + ", taskId=" + this.getTaskId() + ", reasonForIncompletion=" + this.getReasonForIncompletion() + ", callbackAfterSeconds=" + this.getCallbackAfterSeconds() + ", workerId=" + this.getWorkerId() + ", outputData=" + this.getOutputData() + ", workflowTask=" + this.getWorkflowTask() + ", domain=" + this.getDomain() + ", inputMessage=" + this.getInputMessage() + ", outputMessage=" + this.getOutputMessage() + ", rateLimitPerFrequency=" + this.getRateLimitPerFrequency() + ", rateLimitFrequencyInSeconds=" + this.getRateLimitFrequencyInSeconds() + ", externalInputPayloadStoragePath=" + this.getExternalInputPayloadStoragePath() + ", externalOutputPayloadStoragePath=" + this.getExternalOutputPayloadStoragePath() + ", workflowPriority=" + this.getWorkflowPriority() + ", executionNameSpace=" + this.getExecutionNameSpace() + ", isolationGroupId=" + this.getIsolationGroupId() + ", iteration=" + this.getIteration() + ", subWorkflowId=" + this.getSubWorkflowId() + ", subworkflowChanged=" + this.isSubworkflowChanged() + ")";
    }

    public static enum Status {
        IN_PROGRESS(false, true, true),
        CANCELED(true, false, false),
        FAILED(true, false, true),
        FAILED_WITH_TERMINAL_ERROR(true, false, false),
        COMPLETED(true, true, true),
        COMPLETED_WITH_ERRORS(true, true, true),
        SCHEDULED(false, true, true),
        TIMED_OUT(true, false, true),
        SKIPPED(true, true, false);

        private final boolean terminal;
        private final boolean successful;
        private final boolean retriable;

        private Status(boolean terminal, boolean successful, boolean retriable) {
            this.terminal = terminal;
            this.successful = successful;
            this.retriable = retriable;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public boolean isRetriable() {
            return this.retriable;
        }
    }
}

