/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.metadata.tasks;

import cn.feiliu.taskflow.common.constraints.EmailConstraint;
import cn.feiliu.taskflow.common.constraints.TaskNameConstraint;
import cn.feiliu.taskflow.common.constraints.TaskTimeoutConstraint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Valid
@TaskTimeoutConstraint
public class TaskDefinition {
    private static final int ONE_HOUR = 3600;
    @TaskNameConstraint(message="Illegal TaskDef name field")
    private String name;
    private String title;
    private String description;
    @Min(value=0L, message="TaskDef retryCount: {value} must be >= 0")
    private @Min(value=0L, message="TaskDef retryCount: {value} must be >= 0") int retryCount = 3;
    @NotNull
    private long timeoutSeconds;
    private List<String> inputKeys = new ArrayList<String>();
    private List<String> outputKeys = new ArrayList<String>();
    private TimeoutPolicy timeoutPolicy = TimeoutPolicy.TIME_OUT_WF;
    private RetryLogic retryLogic = RetryLogic.FIXED;
    private int retryDelaySeconds = 60;
    @Min(value=1L, message="TaskDef responseTimeoutSeconds: ${validatedValue} should be minimum {value} second")
    private @Min(value=1L, message="TaskDef responseTimeoutSeconds: ${validatedValue} should be minimum {value} second") long responseTimeoutSeconds = 3600L;
    private Integer concurrentExecLimit = 0;
    private Map<String, Object> inputTemplate = new HashMap<String, Object>();
    private Integer rateLimitPerFrequency = 0;
    private Integer rateLimitFrequencyInSeconds = 1;
    private String isolationGroupId;
    private String executionNameSpace;
    @EmailConstraint(message="ownerEmail should be valid email address")
    @Email(message="ownerEmail should be valid email address")
    private @Email(message="ownerEmail should be valid email address") String ownerEmail;
    @Min(value=0L, message="TaskDef pollTimeoutSeconds: {value} must be >= 0")
    private @Min(value=0L, message="TaskDef pollTimeoutSeconds: {value} must be >= 0") Integer pollTimeoutSeconds;
    @Min(value=1L, message="Backoff scale factor. Applicable for LINEAR_BACKOFF")
    private @Min(value=1L, message="Backoff scale factor. Applicable for LINEAR_BACKOFF") Integer backoffScaleFactor = 1;

    public TaskDefinition() {
    }

    public TaskDefinition(String name) {
        this.name = name;
    }

    public TaskDefinition(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public TaskDefinition(String name, String description, int retryCount, long timeoutSeconds) {
        this.name = name;
        this.description = description;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
    }

    public TaskDefinition(String name, String description, String ownerEmail, int retryCount, long timeoutSeconds, long responseTimeoutSeconds) {
        this.name = name;
        this.description = description;
        this.ownerEmail = ownerEmail;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public void addInputKey(String name) {
        this.inputKeys.add(name);
    }

    public void addOutputKey(String name) {
        this.inputKeys.add(name);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    @NotNull
    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public List<String> getInputKeys() {
        return this.inputKeys;
    }

    public List<String> getOutputKeys() {
        return this.outputKeys;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public RetryLogic getRetryLogic() {
        return this.retryLogic;
    }

    public int getRetryDelaySeconds() {
        return this.retryDelaySeconds;
    }

    public long getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public Integer getConcurrentExecLimit() {
        return this.concurrentExecLimit;
    }

    public Map<String, Object> getInputTemplate() {
        return this.inputTemplate;
    }

    public Integer getRateLimitPerFrequency() {
        return this.rateLimitPerFrequency;
    }

    public Integer getRateLimitFrequencyInSeconds() {
        return this.rateLimitFrequencyInSeconds;
    }

    public String getIsolationGroupId() {
        return this.isolationGroupId;
    }

    public String getExecutionNameSpace() {
        return this.executionNameSpace;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public Integer getPollTimeoutSeconds() {
        return this.pollTimeoutSeconds;
    }

    public Integer getBackoffScaleFactor() {
        return this.backoffScaleFactor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setTimeoutSeconds(@NotNull long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setInputKeys(List<String> inputKeys) {
        this.inputKeys = inputKeys;
    }

    public void setOutputKeys(List<String> outputKeys) {
        this.outputKeys = outputKeys;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public void setRetryLogic(RetryLogic retryLogic) {
        this.retryLogic = retryLogic;
    }

    public void setRetryDelaySeconds(int retryDelaySeconds) {
        this.retryDelaySeconds = retryDelaySeconds;
    }

    public void setResponseTimeoutSeconds(long responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public void setConcurrentExecLimit(Integer concurrentExecLimit) {
        this.concurrentExecLimit = concurrentExecLimit;
    }

    public void setInputTemplate(Map<String, Object> inputTemplate) {
        this.inputTemplate = inputTemplate;
    }

    public void setRateLimitPerFrequency(Integer rateLimitPerFrequency) {
        this.rateLimitPerFrequency = rateLimitPerFrequency;
    }

    public void setRateLimitFrequencyInSeconds(Integer rateLimitFrequencyInSeconds) {
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
    }

    public void setIsolationGroupId(String isolationGroupId) {
        this.isolationGroupId = isolationGroupId;
    }

    public void setExecutionNameSpace(String executionNameSpace) {
        this.executionNameSpace = executionNameSpace;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public void setPollTimeoutSeconds(Integer pollTimeoutSeconds) {
        this.pollTimeoutSeconds = pollTimeoutSeconds;
    }

    public void setBackoffScaleFactor(Integer backoffScaleFactor) {
        this.backoffScaleFactor = backoffScaleFactor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskDefinition)) {
            return false;
        }
        TaskDefinition other = (TaskDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRetryCount() != other.getRetryCount()) {
            return false;
        }
        if (this.getTimeoutSeconds() != other.getTimeoutSeconds()) {
            return false;
        }
        if (this.getRetryDelaySeconds() != other.getRetryDelaySeconds()) {
            return false;
        }
        if (this.getResponseTimeoutSeconds() != other.getResponseTimeoutSeconds()) {
            return false;
        }
        Integer this$concurrentExecLimit = this.getConcurrentExecLimit();
        Integer other$concurrentExecLimit = other.getConcurrentExecLimit();
        if (this$concurrentExecLimit == null ? other$concurrentExecLimit != null : !((Object)this$concurrentExecLimit).equals(other$concurrentExecLimit)) {
            return false;
        }
        Integer this$rateLimitPerFrequency = this.getRateLimitPerFrequency();
        Integer other$rateLimitPerFrequency = other.getRateLimitPerFrequency();
        if (this$rateLimitPerFrequency == null ? other$rateLimitPerFrequency != null : !((Object)this$rateLimitPerFrequency).equals(other$rateLimitPerFrequency)) {
            return false;
        }
        Integer this$rateLimitFrequencyInSeconds = this.getRateLimitFrequencyInSeconds();
        Integer other$rateLimitFrequencyInSeconds = other.getRateLimitFrequencyInSeconds();
        if (this$rateLimitFrequencyInSeconds == null ? other$rateLimitFrequencyInSeconds != null : !((Object)this$rateLimitFrequencyInSeconds).equals(other$rateLimitFrequencyInSeconds)) {
            return false;
        }
        Integer this$pollTimeoutSeconds = this.getPollTimeoutSeconds();
        Integer other$pollTimeoutSeconds = other.getPollTimeoutSeconds();
        if (this$pollTimeoutSeconds == null ? other$pollTimeoutSeconds != null : !((Object)this$pollTimeoutSeconds).equals(other$pollTimeoutSeconds)) {
            return false;
        }
        Integer this$backoffScaleFactor = this.getBackoffScaleFactor();
        Integer other$backoffScaleFactor = other.getBackoffScaleFactor();
        if (this$backoffScaleFactor == null ? other$backoffScaleFactor != null : !((Object)this$backoffScaleFactor).equals(other$backoffScaleFactor)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$inputKeys = this.getInputKeys();
        List<String> other$inputKeys = other.getInputKeys();
        if (this$inputKeys == null ? other$inputKeys != null : !((Object)this$inputKeys).equals(other$inputKeys)) {
            return false;
        }
        List<String> this$outputKeys = this.getOutputKeys();
        List<String> other$outputKeys = other.getOutputKeys();
        if (this$outputKeys == null ? other$outputKeys != null : !((Object)this$outputKeys).equals(other$outputKeys)) {
            return false;
        }
        TimeoutPolicy this$timeoutPolicy = this.getTimeoutPolicy();
        TimeoutPolicy other$timeoutPolicy = other.getTimeoutPolicy();
        if (this$timeoutPolicy == null ? other$timeoutPolicy != null : !((Object)((Object)this$timeoutPolicy)).equals((Object)other$timeoutPolicy)) {
            return false;
        }
        RetryLogic this$retryLogic = this.getRetryLogic();
        RetryLogic other$retryLogic = other.getRetryLogic();
        if (this$retryLogic == null ? other$retryLogic != null : !((Object)((Object)this$retryLogic)).equals((Object)other$retryLogic)) {
            return false;
        }
        Map<String, Object> this$inputTemplate = this.getInputTemplate();
        Map<String, Object> other$inputTemplate = other.getInputTemplate();
        if (this$inputTemplate == null ? other$inputTemplate != null : !((Object)this$inputTemplate).equals(other$inputTemplate)) {
            return false;
        }
        String this$isolationGroupId = this.getIsolationGroupId();
        String other$isolationGroupId = other.getIsolationGroupId();
        if (this$isolationGroupId == null ? other$isolationGroupId != null : !this$isolationGroupId.equals(other$isolationGroupId)) {
            return false;
        }
        String this$executionNameSpace = this.getExecutionNameSpace();
        String other$executionNameSpace = other.getExecutionNameSpace();
        if (this$executionNameSpace == null ? other$executionNameSpace != null : !this$executionNameSpace.equals(other$executionNameSpace)) {
            return false;
        }
        String this$ownerEmail = this.getOwnerEmail();
        String other$ownerEmail = other.getOwnerEmail();
        return !(this$ownerEmail == null ? other$ownerEmail != null : !this$ownerEmail.equals(other$ownerEmail));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetryCount();
        long $timeoutSeconds = this.getTimeoutSeconds();
        result = result * 59 + (int)($timeoutSeconds >>> 32 ^ $timeoutSeconds);
        result = result * 59 + this.getRetryDelaySeconds();
        long $responseTimeoutSeconds = this.getResponseTimeoutSeconds();
        result = result * 59 + (int)($responseTimeoutSeconds >>> 32 ^ $responseTimeoutSeconds);
        Integer $concurrentExecLimit = this.getConcurrentExecLimit();
        result = result * 59 + ($concurrentExecLimit == null ? 43 : ((Object)$concurrentExecLimit).hashCode());
        Integer $rateLimitPerFrequency = this.getRateLimitPerFrequency();
        result = result * 59 + ($rateLimitPerFrequency == null ? 43 : ((Object)$rateLimitPerFrequency).hashCode());
        Integer $rateLimitFrequencyInSeconds = this.getRateLimitFrequencyInSeconds();
        result = result * 59 + ($rateLimitFrequencyInSeconds == null ? 43 : ((Object)$rateLimitFrequencyInSeconds).hashCode());
        Integer $pollTimeoutSeconds = this.getPollTimeoutSeconds();
        result = result * 59 + ($pollTimeoutSeconds == null ? 43 : ((Object)$pollTimeoutSeconds).hashCode());
        Integer $backoffScaleFactor = this.getBackoffScaleFactor();
        result = result * 59 + ($backoffScaleFactor == null ? 43 : ((Object)$backoffScaleFactor).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $inputKeys = this.getInputKeys();
        result = result * 59 + ($inputKeys == null ? 43 : ((Object)$inputKeys).hashCode());
        List<String> $outputKeys = this.getOutputKeys();
        result = result * 59 + ($outputKeys == null ? 43 : ((Object)$outputKeys).hashCode());
        TimeoutPolicy $timeoutPolicy = this.getTimeoutPolicy();
        result = result * 59 + ($timeoutPolicy == null ? 43 : ((Object)((Object)$timeoutPolicy)).hashCode());
        RetryLogic $retryLogic = this.getRetryLogic();
        result = result * 59 + ($retryLogic == null ? 43 : ((Object)((Object)$retryLogic)).hashCode());
        Map<String, Object> $inputTemplate = this.getInputTemplate();
        result = result * 59 + ($inputTemplate == null ? 43 : ((Object)$inputTemplate).hashCode());
        String $isolationGroupId = this.getIsolationGroupId();
        result = result * 59 + ($isolationGroupId == null ? 43 : $isolationGroupId.hashCode());
        String $executionNameSpace = this.getExecutionNameSpace();
        result = result * 59 + ($executionNameSpace == null ? 43 : $executionNameSpace.hashCode());
        String $ownerEmail = this.getOwnerEmail();
        result = result * 59 + ($ownerEmail == null ? 43 : $ownerEmail.hashCode());
        return result;
    }

    public String toString() {
        return "TaskDefinition(name=" + this.getName() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", retryCount=" + this.getRetryCount() + ", timeoutSeconds=" + this.getTimeoutSeconds() + ", inputKeys=" + this.getInputKeys() + ", outputKeys=" + this.getOutputKeys() + ", timeoutPolicy=" + this.getTimeoutPolicy() + ", retryLogic=" + this.getRetryLogic() + ", retryDelaySeconds=" + this.getRetryDelaySeconds() + ", responseTimeoutSeconds=" + this.getResponseTimeoutSeconds() + ", concurrentExecLimit=" + this.getConcurrentExecLimit() + ", inputTemplate=" + this.getInputTemplate() + ", rateLimitPerFrequency=" + this.getRateLimitPerFrequency() + ", rateLimitFrequencyInSeconds=" + this.getRateLimitFrequencyInSeconds() + ", isolationGroupId=" + this.getIsolationGroupId() + ", executionNameSpace=" + this.getExecutionNameSpace() + ", ownerEmail=" + this.getOwnerEmail() + ", pollTimeoutSeconds=" + this.getPollTimeoutSeconds() + ", backoffScaleFactor=" + this.getBackoffScaleFactor() + ")";
    }

    public static class Builder {
        private String name;
        private String title;
        private String description;
        private int retryCount = 3;
        private long timeoutSeconds;
        private List<String> inputKeys = new ArrayList<String>();
        private List<String> outputKeys = new ArrayList<String>();
        private TimeoutPolicy timeoutPolicy = TimeoutPolicy.TIME_OUT_WF;
        private RetryLogic retryLogic = RetryLogic.FIXED;
        private int retryDelaySeconds = 60;
        private long responseTimeoutSeconds = 3600L;
        private Integer concurrentExecLimit = 0;
        private Map<String, Object> inputTemplate = new HashMap<String, Object>();
        private Integer rateLimitPerFrequency = 0;
        private Integer rateLimitFrequencyInSeconds = 1;
        private String isolationGroupId;
        private String executionNameSpace;
        private String ownerEmail;
        private Integer pollTimeoutSeconds;
        private Integer backoffScaleFactor = 1;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder retryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public Builder timeoutSeconds(long timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder inputKeys(List<String> inputKeys) {
            this.inputKeys = inputKeys;
            return this;
        }

        public Builder outputKeys(List<String> outputKeys) {
            this.outputKeys = outputKeys;
            return this;
        }

        public Builder timeoutPolicy(TimeoutPolicy timeoutPolicy) {
            this.timeoutPolicy = timeoutPolicy;
            return this;
        }

        public Builder retryLogic(RetryLogic retryLogic) {
            this.retryLogic = retryLogic;
            return this;
        }

        public Builder retryDelaySeconds(int retryDelaySeconds) {
            this.retryDelaySeconds = retryDelaySeconds;
            return this;
        }

        public Builder responseTimeoutSeconds(long responseTimeoutSeconds) {
            this.responseTimeoutSeconds = responseTimeoutSeconds;
            return this;
        }

        public Builder concurrentExecLimit(Integer concurrentExecLimit) {
            this.concurrentExecLimit = concurrentExecLimit;
            return this;
        }

        public Builder inputTemplate(Map<String, Object> inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public Builder rateLimitPerFrequency(Integer rateLimitPerFrequency) {
            this.rateLimitPerFrequency = rateLimitPerFrequency;
            return this;
        }

        public Builder rateLimitFrequencyInSeconds(Integer rateLimitFrequencyInSeconds) {
            this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
            return this;
        }

        public Builder isolationGroupId(String isolationGroupId) {
            this.isolationGroupId = isolationGroupId;
            return this;
        }

        public Builder executionNameSpace(String executionNameSpace) {
            this.executionNameSpace = executionNameSpace;
            return this;
        }

        public Builder ownerEmail(String ownerEmail) {
            this.ownerEmail = ownerEmail;
            return this;
        }

        public Builder pollTimeoutSeconds(Integer pollTimeoutSeconds) {
            this.pollTimeoutSeconds = pollTimeoutSeconds;
            return this;
        }

        public Builder backoffScaleFactor(Integer backoffScaleFactor) {
            this.backoffScaleFactor = backoffScaleFactor;
            return this;
        }

        public TaskDefinition build() {
            TaskDefinition taskDefinition = new TaskDefinition();
            taskDefinition.name = this.name;
            taskDefinition.title = this.title;
            taskDefinition.description = this.description;
            taskDefinition.retryCount = this.retryCount;
            taskDefinition.timeoutSeconds = this.timeoutSeconds;
            taskDefinition.inputKeys = this.inputKeys;
            taskDefinition.outputKeys = this.outputKeys;
            taskDefinition.timeoutPolicy = this.timeoutPolicy;
            taskDefinition.retryLogic = this.retryLogic;
            taskDefinition.retryDelaySeconds = this.retryDelaySeconds;
            taskDefinition.responseTimeoutSeconds = this.responseTimeoutSeconds;
            taskDefinition.concurrentExecLimit = this.concurrentExecLimit;
            taskDefinition.inputTemplate = this.inputTemplate;
            taskDefinition.rateLimitPerFrequency = this.rateLimitPerFrequency;
            taskDefinition.rateLimitFrequencyInSeconds = this.rateLimitFrequencyInSeconds;
            taskDefinition.isolationGroupId = this.isolationGroupId;
            taskDefinition.executionNameSpace = this.executionNameSpace;
            taskDefinition.ownerEmail = this.ownerEmail;
            taskDefinition.pollTimeoutSeconds = this.pollTimeoutSeconds;
            taskDefinition.backoffScaleFactor = this.backoffScaleFactor;
            return taskDefinition;
        }
    }

    public static enum RetryLogic {
        FIXED,
        EXPONENTIAL_BACKOFF,
        LINEAR_BACKOFF;

    }

    public static enum TimeoutPolicy {
        RETRY,
        TIME_OUT_WF,
        ALERT_ONLY;

    }
}

