/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.metadata.tasks;

import cn.feiliu.taskflow.common.metadata.tasks.ExecutingTask;
import cn.feiliu.taskflow.common.metadata.tasks.TaskLog;
import com.google.protobuf.Any;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;

public class TaskExecResult {
    @NotEmpty(message="Workflow Id cannot be null or empty")
    private @NotEmpty(message="Workflow Id cannot be null or empty") String workflowInstanceId;
    @NotEmpty(message="Task ID cannot be null or empty")
    private @NotEmpty(message="Task ID cannot be null or empty") String taskId;
    private String reasonForIncompletion;
    private long callbackAfterSeconds;
    private String workerId;
    private Status status;
    private Map<String, Object> outputData = new HashMap<String, Object>();
    private Any outputMessage;
    private List<TaskLog> logs = new CopyOnWriteArrayList<TaskLog>();
    private String externalOutputPayloadStoragePath;
    private String subWorkflowId;

    public TaskExecResult(ExecutingTask task) {
        this.workflowInstanceId = task.getWorkflowInstanceId();
        this.taskId = task.getTaskId();
        this.reasonForIncompletion = task.getReasonForIncompletion();
        this.callbackAfterSeconds = task.getCallbackAfterSeconds();
        this.workerId = task.getWorkerId();
        this.outputData = task.getOutputData();
        this.externalOutputPayloadStoragePath = task.getExternalOutputPayloadStoragePath();
        this.subWorkflowId = task.getSubWorkflowId();
        switch (task.getStatus()) {
            case CANCELED: 
            case COMPLETED_WITH_ERRORS: 
            case TIMED_OUT: 
            case SKIPPED: {
                this.status = Status.FAILED;
                break;
            }
            case SCHEDULED: {
                this.status = Status.IN_PROGRESS;
                break;
            }
            default: {
                this.status = Status.valueOf(task.getStatus().name());
            }
        }
    }

    public TaskExecResult() {
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = StringUtils.substring((String)reasonForIncompletion, (int)0, (int)500);
    }

    public TaskExecResult addOutputData(String key, Object value) {
        this.outputData.put(key, value);
        return this;
    }

    public TaskExecResult log(String log) {
        this.logs.add(new TaskLog(this.taskId, log));
        return this;
    }

    public static TaskExecResult complete() {
        return TaskExecResult.newTaskResult(Status.COMPLETED);
    }

    public static TaskExecResult failed() {
        return TaskExecResult.newTaskResult(Status.FAILED);
    }

    public static TaskExecResult failed(String failureReason) {
        TaskExecResult result = TaskExecResult.newTaskResult(Status.FAILED);
        result.setReasonForIncompletion(failureReason);
        return result;
    }

    public static TaskExecResult inProgress() {
        return TaskExecResult.newTaskResult(Status.IN_PROGRESS);
    }

    public static TaskExecResult newTaskResult(Status status) {
        TaskExecResult result = new TaskExecResult();
        result.setStatus(status);
        return result;
    }

    public TaskExecResult copy() {
        TaskExecResult taskExecResult = new TaskExecResult();
        taskExecResult.setReasonForIncompletion(this.reasonForIncompletion);
        taskExecResult.setWorkflowInstanceId(this.workflowInstanceId);
        taskExecResult.setTaskId(this.taskId);
        taskExecResult.setCallbackAfterSeconds(this.callbackAfterSeconds);
        taskExecResult.setWorkerId(this.workerId);
        taskExecResult.setStatus(this.status);
        taskExecResult.setOutputData(this.outputData);
        taskExecResult.setOutputMessage(this.outputMessage);
        taskExecResult.setLogs(this.logs);
        taskExecResult.setExternalOutputPayloadStoragePath(this.externalOutputPayloadStoragePath);
        taskExecResult.setSubWorkflowId(this.subWorkflowId);
        return taskExecResult;
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public long getCallbackAfterSeconds() {
        return this.callbackAfterSeconds;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public Status getStatus() {
        return this.status;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public Any getOutputMessage() {
        return this.outputMessage;
    }

    public List<TaskLog> getLogs() {
        return this.logs;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public String getSubWorkflowId() {
        return this.subWorkflowId;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setCallbackAfterSeconds(long callbackAfterSeconds) {
        this.callbackAfterSeconds = callbackAfterSeconds;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public void setOutputMessage(Any outputMessage) {
        this.outputMessage = outputMessage;
    }

    public void setLogs(List<TaskLog> logs) {
        this.logs = logs;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public void setSubWorkflowId(String subWorkflowId) {
        this.subWorkflowId = subWorkflowId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecResult)) {
            return false;
        }
        TaskExecResult other = (TaskExecResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCallbackAfterSeconds() != other.getCallbackAfterSeconds()) {
            return false;
        }
        String this$workflowInstanceId = this.getWorkflowInstanceId();
        String other$workflowInstanceId = other.getWorkflowInstanceId();
        if (this$workflowInstanceId == null ? other$workflowInstanceId != null : !this$workflowInstanceId.equals(other$workflowInstanceId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$reasonForIncompletion = this.getReasonForIncompletion();
        String other$reasonForIncompletion = other.getReasonForIncompletion();
        if (this$reasonForIncompletion == null ? other$reasonForIncompletion != null : !this$reasonForIncompletion.equals(other$reasonForIncompletion)) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Map<String, Object> this$outputData = this.getOutputData();
        Map<String, Object> other$outputData = other.getOutputData();
        if (this$outputData == null ? other$outputData != null : !((Object)this$outputData).equals(other$outputData)) {
            return false;
        }
        Any this$outputMessage = this.getOutputMessage();
        Any other$outputMessage = other.getOutputMessage();
        if (this$outputMessage == null ? other$outputMessage != null : !this$outputMessage.equals(other$outputMessage)) {
            return false;
        }
        List<TaskLog> this$logs = this.getLogs();
        List<TaskLog> other$logs = other.getLogs();
        if (this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs)) {
            return false;
        }
        String this$externalOutputPayloadStoragePath = this.getExternalOutputPayloadStoragePath();
        String other$externalOutputPayloadStoragePath = other.getExternalOutputPayloadStoragePath();
        if (this$externalOutputPayloadStoragePath == null ? other$externalOutputPayloadStoragePath != null : !this$externalOutputPayloadStoragePath.equals(other$externalOutputPayloadStoragePath)) {
            return false;
        }
        String this$subWorkflowId = this.getSubWorkflowId();
        String other$subWorkflowId = other.getSubWorkflowId();
        return !(this$subWorkflowId == null ? other$subWorkflowId != null : !this$subWorkflowId.equals(other$subWorkflowId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskExecResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $callbackAfterSeconds = this.getCallbackAfterSeconds();
        result = result * 59 + (int)($callbackAfterSeconds >>> 32 ^ $callbackAfterSeconds);
        String $workflowInstanceId = this.getWorkflowInstanceId();
        result = result * 59 + ($workflowInstanceId == null ? 43 : $workflowInstanceId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $reasonForIncompletion = this.getReasonForIncompletion();
        result = result * 59 + ($reasonForIncompletion == null ? 43 : $reasonForIncompletion.hashCode());
        String $workerId = this.getWorkerId();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Map<String, Object> $outputData = this.getOutputData();
        result = result * 59 + ($outputData == null ? 43 : ((Object)$outputData).hashCode());
        Any $outputMessage = this.getOutputMessage();
        result = result * 59 + ($outputMessage == null ? 43 : $outputMessage.hashCode());
        List<TaskLog> $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
        String $externalOutputPayloadStoragePath = this.getExternalOutputPayloadStoragePath();
        result = result * 59 + ($externalOutputPayloadStoragePath == null ? 43 : $externalOutputPayloadStoragePath.hashCode());
        String $subWorkflowId = this.getSubWorkflowId();
        result = result * 59 + ($subWorkflowId == null ? 43 : $subWorkflowId.hashCode());
        return result;
    }

    public String toString() {
        return "TaskExecResult(workflowInstanceId=" + this.getWorkflowInstanceId() + ", taskId=" + this.getTaskId() + ", reasonForIncompletion=" + this.getReasonForIncompletion() + ", callbackAfterSeconds=" + this.getCallbackAfterSeconds() + ", workerId=" + this.getWorkerId() + ", status=" + this.getStatus() + ", outputData=" + this.getOutputData() + ", outputMessage=" + this.getOutputMessage() + ", logs=" + this.getLogs() + ", externalOutputPayloadStoragePath=" + this.getExternalOutputPayloadStoragePath() + ", subWorkflowId=" + this.getSubWorkflowId() + ")";
    }

    public static enum Status {
        IN_PROGRESS,
        FAILED,
        FAILED_WITH_TERMINAL_ERROR,
        COMPLETED;

    }
}

