/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.metadata.tasks;

public enum TaskType {
    SIMPLE,
    DYNAMIC,
    FORK_JOIN,
    FORK_JOIN_DYNAMIC,
    DECISION,
    SWITCH,
    JOIN,
    DO_WHILE,
    FOR_EACH,
    FORK_FOR_EACH,
    SUB_WORKFLOW,
    START_WORKFLOW,
    EVENT,
    WAIT,
    USER_DEFINED,
    HTTP,
    LAMBDA,
    INLINE,
    EXCLUSIVE_JOIN,
    TERMINATE,
    KAFKA_PUBLISH,
    JSON_JQ_TRANSFORM,
    SET_VARIABLE;


    public static TaskType of(String taskType) {
        try {
            return TaskType.valueOf(taskType);
        }
        catch (IllegalArgumentException iae) {
            return USER_DEFINED;
        }
    }

    public boolean isForEach() {
        return this == FOR_EACH;
    }

    public boolean isForkForEach() {
        return this == FORK_FOR_EACH;
    }

    public boolean isSimple() {
        return this == SIMPLE;
    }

    public boolean isSubWorkflow() {
        return this == SUB_WORKFLOW;
    }
}

