/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.metadata.workflow;

import cn.feiliu.taskflow.common.metadata.tasks.TaskDefinition;
import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.SubFlowParams;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.PositiveOrZero;

public class FlowTask {
    @NotEmpty(message="FlowTask name cannot be empty or null")
    private @NotEmpty(message="FlowTask name cannot be empty or null") String name;
    @NotEmpty(message="FlowTask taskReferenceName name cannot be empty or null")
    private @NotEmpty(message="FlowTask taskReferenceName name cannot be empty or null") String taskReferenceName;
    private String description;
    private Map<String, Object> inputParameters = new HashMap<String, Object>();
    private TaskType type = TaskType.SIMPLE;
    private String dynamicTaskNameParam;
    @Deprecated
    private String caseValueParam;
    @Deprecated
    private String caseExpression;
    private String scriptExpression;
    private Map<String, @Valid List<@Valid FlowTask>> decisionCases = new LinkedHashMap<String, List<FlowTask>>();
    @Deprecated
    private String dynamicForkJoinTasksParam;
    private String dynamicForkTasksParam;
    private String dynamicForkTasksInputParamName;
    private List<@Valid FlowTask> defaultCase = new LinkedList<FlowTask>();
    private List<@Valid List<@Valid FlowTask>> forkTasks = new LinkedList<List<FlowTask>>();
    @PositiveOrZero
    private int startDelay;
    @Valid
    private SubFlowParams subWorkflowParam;
    private List<String> joinOn = new LinkedList<String>();
    private String sink;
    private boolean optional = false;
    private TaskDefinition taskDefinition;
    private boolean rateLimited;
    private List<String> defaultExclusiveJoinTask = new LinkedList<String>();
    private boolean asyncComplete = false;
    private String loopCondition;
    private List<FlowTask> loopOver = new LinkedList<FlowTask>();
    private Integer retryCount = 3;
    private String evaluatorType;
    private String expression;

    public void copyFrom(FlowTask flowTask) {
        this.setName(flowTask.getName());
        this.setTaskReferenceName(flowTask.getTaskReferenceName());
        this.setDescription(flowTask.getDescription());
        this.setInputParameters(flowTask.getInputParameters());
        this.setType(flowTask.getType());
        this.setDynamicTaskNameParam(flowTask.getDynamicTaskNameParam());
        this.setCaseValueParam(flowTask.getCaseValueParam());
        this.setCaseExpression(flowTask.getCaseExpression());
        this.setScriptExpression(flowTask.getScriptExpression());
        this.setDecisionCases(flowTask.getDecisionCases());
        this.setDynamicForkJoinTasksParam(flowTask.getDynamicForkJoinTasksParam());
        this.setDynamicForkTasksParam(flowTask.getDynamicForkTasksParam());
        this.setDynamicForkTasksInputParamName(flowTask.getDynamicForkTasksInputParamName());
        this.setDefaultCase(flowTask.getDefaultCase());
        this.setForkTasks(flowTask.getForkTasks());
        this.setStartDelay(flowTask.getStartDelay());
        this.setSubWorkflowParam(flowTask.getSubWorkflowParam());
        this.setJoinOn(flowTask.getJoinOn());
        this.setSink(flowTask.getSink());
        this.setOptional(flowTask.isOptional());
        this.setTaskDefinition(flowTask.getTaskDefinition());
        this.setRateLimited(flowTask.isRateLimited());
        this.setDefaultExclusiveJoinTask(flowTask.getDefaultExclusiveJoinTask());
        this.setAsyncComplete(flowTask.isAsyncComplete());
        this.setLoopCondition(flowTask.getLoopCondition());
        this.setLoopOver(flowTask.getLoopOver());
        this.setRetryCount(flowTask.getRetryCount());
        this.setEvaluatorType(flowTask.getEvaluatorType());
        this.setExpression(flowTask.getExpression());
    }

    private Collection<List<FlowTask>> children() {
        LinkedList<List<FlowTask>> workflowTaskLists = new LinkedList<List<FlowTask>>();
        switch (this.type) {
            case DECISION: 
            case SWITCH: {
                workflowTaskLists.addAll(this.decisionCases.values());
                workflowTaskLists.add(this.defaultCase);
                break;
            }
            case FORK_JOIN: {
                workflowTaskLists.addAll(this.forkTasks);
                break;
            }
            case DO_WHILE: 
            case FOR_EACH: 
            case FORK_FOR_EACH: {
                workflowTaskLists.add(this.loopOver);
                break;
            }
        }
        return workflowTaskLists;
    }

    public List<FlowTask> collectTasks() {
        LinkedList<FlowTask> tasks = new LinkedList<FlowTask>();
        tasks.add(this);
        for (List<FlowTask> workflowTaskList : this.children()) {
            for (FlowTask workflowTask : workflowTaskList) {
                tasks.addAll(workflowTask.collectTasks());
            }
        }
        return tasks;
    }

    public FlowTask next(String taskReferenceName, FlowTask parent) {
        switch (this.type) {
            case DECISION: 
            case SWITCH: 
            case DO_WHILE: 
            case FOR_EACH: 
            case FORK_FOR_EACH: {
                for (List<FlowTask> workflowTasks : this.children()) {
                    FlowTask task;
                    Iterator<FlowTask> iterator = workflowTasks.iterator();
                    while (iterator.hasNext() && !(task = iterator.next()).getTaskReferenceName().equals(taskReferenceName)) {
                        FlowTask nextTask = task.next(taskReferenceName, this);
                        if (nextTask != null) {
                            return nextTask;
                        }
                        if (!task.has(taskReferenceName)) continue;
                        break;
                    }
                    if (!iterator.hasNext()) continue;
                    return iterator.next();
                }
                if (this.type != TaskType.DO_WHILE || !this.has(taskReferenceName)) break;
                return this;
            }
            case FORK_JOIN: {
                boolean found = false;
                for (List<FlowTask> workflowTasks : this.children()) {
                    Iterator<FlowTask> iterator = workflowTasks.iterator();
                    while (iterator.hasNext()) {
                        FlowTask task = iterator.next();
                        if (task.getTaskReferenceName().equals(taskReferenceName)) {
                            found = true;
                            break;
                        }
                        FlowTask nextTask = task.next(taskReferenceName, this);
                        if (nextTask != null) {
                            return nextTask;
                        }
                        if (!task.has(taskReferenceName)) continue;
                        break;
                    }
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    if (!found || parent == null) continue;
                    return parent.next(this.taskReferenceName, parent);
                }
                break;
            }
            case DYNAMIC: 
            case TERMINATE: 
            case SIMPLE: {
                return null;
            }
        }
        return null;
    }

    public boolean has(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return true;
        }
        switch (this.type) {
            case DECISION: 
            case SWITCH: 
            case FORK_JOIN: 
            case DO_WHILE: 
            case FOR_EACH: 
            case FORK_FOR_EACH: {
                for (List<FlowTask> childx : this.children()) {
                    for (FlowTask child : childx) {
                        if (!child.has(taskReferenceName)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public FlowTask get(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return this;
        }
        for (List<FlowTask> childx : this.children()) {
            for (FlowTask child : childx) {
                FlowTask found = child.get(taskReferenceName);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public String toString() {
        return this.name + "/" + this.taskReferenceName;
    }

    public String getName() {
        return this.name;
    }

    public String getTaskReferenceName() {
        return this.taskReferenceName;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getInputParameters() {
        return this.inputParameters;
    }

    public TaskType getType() {
        return this.type;
    }

    public String getDynamicTaskNameParam() {
        return this.dynamicTaskNameParam;
    }

    @Deprecated
    public String getCaseValueParam() {
        return this.caseValueParam;
    }

    @Deprecated
    public String getCaseExpression() {
        return this.caseExpression;
    }

    public String getScriptExpression() {
        return this.scriptExpression;
    }

    public Map<String, @Valid List<@Valid FlowTask>> getDecisionCases() {
        return this.decisionCases;
    }

    @Deprecated
    public String getDynamicForkJoinTasksParam() {
        return this.dynamicForkJoinTasksParam;
    }

    public String getDynamicForkTasksParam() {
        return this.dynamicForkTasksParam;
    }

    public String getDynamicForkTasksInputParamName() {
        return this.dynamicForkTasksInputParamName;
    }

    public List<@Valid FlowTask> getDefaultCase() {
        return this.defaultCase;
    }

    public List<@Valid List<@Valid FlowTask>> getForkTasks() {
        return this.forkTasks;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public SubFlowParams getSubWorkflowParam() {
        return this.subWorkflowParam;
    }

    public List<String> getJoinOn() {
        return this.joinOn;
    }

    public String getSink() {
        return this.sink;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    public boolean isRateLimited() {
        return this.rateLimited;
    }

    public List<String> getDefaultExclusiveJoinTask() {
        return this.defaultExclusiveJoinTask;
    }

    public boolean isAsyncComplete() {
        return this.asyncComplete;
    }

    public String getLoopCondition() {
        return this.loopCondition;
    }

    public List<FlowTask> getLoopOver() {
        return this.loopOver;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public String getEvaluatorType() {
        return this.evaluatorType;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTaskReferenceName(String taskReferenceName) {
        this.taskReferenceName = taskReferenceName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public void setType(TaskType type) {
        this.type = type;
    }

    public void setDynamicTaskNameParam(String dynamicTaskNameParam) {
        this.dynamicTaskNameParam = dynamicTaskNameParam;
    }

    @Deprecated
    public void setCaseValueParam(String caseValueParam) {
        this.caseValueParam = caseValueParam;
    }

    @Deprecated
    public void setCaseExpression(String caseExpression) {
        this.caseExpression = caseExpression;
    }

    public void setScriptExpression(String scriptExpression) {
        this.scriptExpression = scriptExpression;
    }

    public void setDecisionCases(Map<String, @Valid List<@Valid FlowTask>> decisionCases) {
        this.decisionCases = decisionCases;
    }

    @Deprecated
    public void setDynamicForkJoinTasksParam(String dynamicForkJoinTasksParam) {
        this.dynamicForkJoinTasksParam = dynamicForkJoinTasksParam;
    }

    public void setDynamicForkTasksParam(String dynamicForkTasksParam) {
        this.dynamicForkTasksParam = dynamicForkTasksParam;
    }

    public void setDynamicForkTasksInputParamName(String dynamicForkTasksInputParamName) {
        this.dynamicForkTasksInputParamName = dynamicForkTasksInputParamName;
    }

    public void setDefaultCase(List<@Valid FlowTask> defaultCase) {
        this.defaultCase = defaultCase;
    }

    public void setForkTasks(List<@Valid List<@Valid FlowTask>> forkTasks) {
        this.forkTasks = forkTasks;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public void setSubWorkflowParam(SubFlowParams subWorkflowParam) {
        this.subWorkflowParam = subWorkflowParam;
    }

    public void setJoinOn(List<String> joinOn) {
        this.joinOn = joinOn;
    }

    public void setSink(String sink) {
        this.sink = sink;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setTaskDefinition(TaskDefinition taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public void setRateLimited(boolean rateLimited) {
        this.rateLimited = rateLimited;
    }

    public void setDefaultExclusiveJoinTask(List<String> defaultExclusiveJoinTask) {
        this.defaultExclusiveJoinTask = defaultExclusiveJoinTask;
    }

    public void setAsyncComplete(boolean asyncComplete) {
        this.asyncComplete = asyncComplete;
    }

    public void setLoopCondition(String loopCondition) {
        this.loopCondition = loopCondition;
    }

    public void setLoopOver(List<FlowTask> loopOver) {
        this.loopOver = loopOver;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public void setEvaluatorType(String evaluatorType) {
        this.evaluatorType = evaluatorType;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowTask)) {
            return false;
        }
        FlowTask other = (FlowTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartDelay() != other.getStartDelay()) {
            return false;
        }
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        if (this.isRateLimited() != other.isRateLimited()) {
            return false;
        }
        if (this.isAsyncComplete() != other.isAsyncComplete()) {
            return false;
        }
        Integer this$retryCount = this.getRetryCount();
        Integer other$retryCount = other.getRetryCount();
        if (this$retryCount == null ? other$retryCount != null : !((Object)this$retryCount).equals(other$retryCount)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$taskReferenceName = this.getTaskReferenceName();
        String other$taskReferenceName = other.getTaskReferenceName();
        if (this$taskReferenceName == null ? other$taskReferenceName != null : !this$taskReferenceName.equals(other$taskReferenceName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, Object> this$inputParameters = this.getInputParameters();
        Map<String, Object> other$inputParameters = other.getInputParameters();
        if (this$inputParameters == null ? other$inputParameters != null : !((Object)this$inputParameters).equals(other$inputParameters)) {
            return false;
        }
        TaskType this$type = this.getType();
        TaskType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$dynamicTaskNameParam = this.getDynamicTaskNameParam();
        String other$dynamicTaskNameParam = other.getDynamicTaskNameParam();
        if (this$dynamicTaskNameParam == null ? other$dynamicTaskNameParam != null : !this$dynamicTaskNameParam.equals(other$dynamicTaskNameParam)) {
            return false;
        }
        String this$caseValueParam = this.getCaseValueParam();
        String other$caseValueParam = other.getCaseValueParam();
        if (this$caseValueParam == null ? other$caseValueParam != null : !this$caseValueParam.equals(other$caseValueParam)) {
            return false;
        }
        String this$caseExpression = this.getCaseExpression();
        String other$caseExpression = other.getCaseExpression();
        if (this$caseExpression == null ? other$caseExpression != null : !this$caseExpression.equals(other$caseExpression)) {
            return false;
        }
        String this$scriptExpression = this.getScriptExpression();
        String other$scriptExpression = other.getScriptExpression();
        if (this$scriptExpression == null ? other$scriptExpression != null : !this$scriptExpression.equals(other$scriptExpression)) {
            return false;
        }
        Map<String, List<FlowTask>> this$decisionCases = this.getDecisionCases();
        Map<String, List<FlowTask>> other$decisionCases = other.getDecisionCases();
        if (this$decisionCases == null ? other$decisionCases != null : !((Object)this$decisionCases).equals(other$decisionCases)) {
            return false;
        }
        String this$dynamicForkJoinTasksParam = this.getDynamicForkJoinTasksParam();
        String other$dynamicForkJoinTasksParam = other.getDynamicForkJoinTasksParam();
        if (this$dynamicForkJoinTasksParam == null ? other$dynamicForkJoinTasksParam != null : !this$dynamicForkJoinTasksParam.equals(other$dynamicForkJoinTasksParam)) {
            return false;
        }
        String this$dynamicForkTasksParam = this.getDynamicForkTasksParam();
        String other$dynamicForkTasksParam = other.getDynamicForkTasksParam();
        if (this$dynamicForkTasksParam == null ? other$dynamicForkTasksParam != null : !this$dynamicForkTasksParam.equals(other$dynamicForkTasksParam)) {
            return false;
        }
        String this$dynamicForkTasksInputParamName = this.getDynamicForkTasksInputParamName();
        String other$dynamicForkTasksInputParamName = other.getDynamicForkTasksInputParamName();
        if (this$dynamicForkTasksInputParamName == null ? other$dynamicForkTasksInputParamName != null : !this$dynamicForkTasksInputParamName.equals(other$dynamicForkTasksInputParamName)) {
            return false;
        }
        List<FlowTask> this$defaultCase = this.getDefaultCase();
        List<FlowTask> other$defaultCase = other.getDefaultCase();
        if (this$defaultCase == null ? other$defaultCase != null : !((Object)this$defaultCase).equals(other$defaultCase)) {
            return false;
        }
        List<List<FlowTask>> this$forkTasks = this.getForkTasks();
        List<List<FlowTask>> other$forkTasks = other.getForkTasks();
        if (this$forkTasks == null ? other$forkTasks != null : !((Object)this$forkTasks).equals(other$forkTasks)) {
            return false;
        }
        SubFlowParams this$subWorkflowParam = this.getSubWorkflowParam();
        SubFlowParams other$subWorkflowParam = other.getSubWorkflowParam();
        if (this$subWorkflowParam == null ? other$subWorkflowParam != null : !((Object)this$subWorkflowParam).equals(other$subWorkflowParam)) {
            return false;
        }
        List<String> this$joinOn = this.getJoinOn();
        List<String> other$joinOn = other.getJoinOn();
        if (this$joinOn == null ? other$joinOn != null : !((Object)this$joinOn).equals(other$joinOn)) {
            return false;
        }
        String this$sink = this.getSink();
        String other$sink = other.getSink();
        if (this$sink == null ? other$sink != null : !this$sink.equals(other$sink)) {
            return false;
        }
        TaskDefinition this$taskDefinition = this.getTaskDefinition();
        TaskDefinition other$taskDefinition = other.getTaskDefinition();
        if (this$taskDefinition == null ? other$taskDefinition != null : !((Object)this$taskDefinition).equals(other$taskDefinition)) {
            return false;
        }
        List<String> this$defaultExclusiveJoinTask = this.getDefaultExclusiveJoinTask();
        List<String> other$defaultExclusiveJoinTask = other.getDefaultExclusiveJoinTask();
        if (this$defaultExclusiveJoinTask == null ? other$defaultExclusiveJoinTask != null : !((Object)this$defaultExclusiveJoinTask).equals(other$defaultExclusiveJoinTask)) {
            return false;
        }
        String this$loopCondition = this.getLoopCondition();
        String other$loopCondition = other.getLoopCondition();
        if (this$loopCondition == null ? other$loopCondition != null : !this$loopCondition.equals(other$loopCondition)) {
            return false;
        }
        List<FlowTask> this$loopOver = this.getLoopOver();
        List<FlowTask> other$loopOver = other.getLoopOver();
        if (this$loopOver == null ? other$loopOver != null : !((Object)this$loopOver).equals(other$loopOver)) {
            return false;
        }
        String this$evaluatorType = this.getEvaluatorType();
        String other$evaluatorType = other.getEvaluatorType();
        if (this$evaluatorType == null ? other$evaluatorType != null : !this$evaluatorType.equals(other$evaluatorType)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStartDelay();
        result = result * 59 + (this.isOptional() ? 79 : 97);
        result = result * 59 + (this.isRateLimited() ? 79 : 97);
        result = result * 59 + (this.isAsyncComplete() ? 79 : 97);
        Integer $retryCount = this.getRetryCount();
        result = result * 59 + ($retryCount == null ? 43 : ((Object)$retryCount).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $taskReferenceName = this.getTaskReferenceName();
        result = result * 59 + ($taskReferenceName == null ? 43 : $taskReferenceName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, Object> $inputParameters = this.getInputParameters();
        result = result * 59 + ($inputParameters == null ? 43 : ((Object)$inputParameters).hashCode());
        TaskType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $dynamicTaskNameParam = this.getDynamicTaskNameParam();
        result = result * 59 + ($dynamicTaskNameParam == null ? 43 : $dynamicTaskNameParam.hashCode());
        String $caseValueParam = this.getCaseValueParam();
        result = result * 59 + ($caseValueParam == null ? 43 : $caseValueParam.hashCode());
        String $caseExpression = this.getCaseExpression();
        result = result * 59 + ($caseExpression == null ? 43 : $caseExpression.hashCode());
        String $scriptExpression = this.getScriptExpression();
        result = result * 59 + ($scriptExpression == null ? 43 : $scriptExpression.hashCode());
        Map<String, List<FlowTask>> $decisionCases = this.getDecisionCases();
        result = result * 59 + ($decisionCases == null ? 43 : ((Object)$decisionCases).hashCode());
        String $dynamicForkJoinTasksParam = this.getDynamicForkJoinTasksParam();
        result = result * 59 + ($dynamicForkJoinTasksParam == null ? 43 : $dynamicForkJoinTasksParam.hashCode());
        String $dynamicForkTasksParam = this.getDynamicForkTasksParam();
        result = result * 59 + ($dynamicForkTasksParam == null ? 43 : $dynamicForkTasksParam.hashCode());
        String $dynamicForkTasksInputParamName = this.getDynamicForkTasksInputParamName();
        result = result * 59 + ($dynamicForkTasksInputParamName == null ? 43 : $dynamicForkTasksInputParamName.hashCode());
        List<FlowTask> $defaultCase = this.getDefaultCase();
        result = result * 59 + ($defaultCase == null ? 43 : ((Object)$defaultCase).hashCode());
        List<List<FlowTask>> $forkTasks = this.getForkTasks();
        result = result * 59 + ($forkTasks == null ? 43 : ((Object)$forkTasks).hashCode());
        SubFlowParams $subWorkflowParam = this.getSubWorkflowParam();
        result = result * 59 + ($subWorkflowParam == null ? 43 : ((Object)$subWorkflowParam).hashCode());
        List<String> $joinOn = this.getJoinOn();
        result = result * 59 + ($joinOn == null ? 43 : ((Object)$joinOn).hashCode());
        String $sink = this.getSink();
        result = result * 59 + ($sink == null ? 43 : $sink.hashCode());
        TaskDefinition $taskDefinition = this.getTaskDefinition();
        result = result * 59 + ($taskDefinition == null ? 43 : ((Object)$taskDefinition).hashCode());
        List<String> $defaultExclusiveJoinTask = this.getDefaultExclusiveJoinTask();
        result = result * 59 + ($defaultExclusiveJoinTask == null ? 43 : ((Object)$defaultExclusiveJoinTask).hashCode());
        String $loopCondition = this.getLoopCondition();
        result = result * 59 + ($loopCondition == null ? 43 : $loopCondition.hashCode());
        List<FlowTask> $loopOver = this.getLoopOver();
        result = result * 59 + ($loopOver == null ? 43 : ((Object)$loopOver).hashCode());
        String $evaluatorType = this.getEvaluatorType();
        result = result * 59 + ($evaluatorType == null ? 43 : $evaluatorType.hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }

    public static class WorkflowTaskList {
        private List<FlowTask> tasks;

        public List<FlowTask> getTasks() {
            return this.tasks;
        }

        public void setTasks(List<FlowTask> tasks) {
            this.tasks = tasks;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkflowTaskList)) {
                return false;
            }
            WorkflowTaskList other = (WorkflowTaskList)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<FlowTask> this$tasks = this.getTasks();
            List<FlowTask> other$tasks = other.getTasks();
            return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WorkflowTaskList;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<FlowTask> $tasks = this.getTasks();
            result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
            return result;
        }

        public String toString() {
            return "FlowTask.WorkflowTaskList(tasks=" + this.getTasks() + ")";
        }
    }
}

