/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.metadata.workflow;

import cn.feiliu.taskflow.common.constraints.WorkflowNameConstraint;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class StartWorkflowRequest {
    @WorkflowNameConstraint(message="Invalid workflow name")
    private String name;
    private Integer version = 1;
    private String correlationId;
    private Map<String, Object> input = new HashMap<String, Object>();
    private Map<String, String> taskToDomain = new HashMap<String, String>();
    private String externalInputPayloadStoragePath;
    @Min(value=0L, message="priority: ${validatedValue} should be minimum {value}")
    @Max(value=99L, message="priority: ${validatedValue} should be maximum {value}")
    private @Min(value=0L, message="priority: ${validatedValue} should be minimum {value}") @Max(value=99L, message="priority: ${validatedValue} should be maximum {value}") Integer priority = 0;
    private String idempotencyKey;
    private IdempotencyStrategy idempotencyStrategy = IdempotencyStrategy.FAIL;

    public static StartWorkflowRequest of(String name, Integer version) {
        Objects.requireNonNull(name, "workflow name cannot be null");
        if (version < 1) {
            throw new IllegalArgumentException("invalid workflow version");
        }
        StartWorkflowRequest request = new StartWorkflowRequest();
        request.setName(name);
        request.setVersion(version);
        return request;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "StartWorkflowRequest{name='" + this.name + "', version=" + this.version + ", correlationId='" + this.correlationId + "', input=" + this.input + ", taskToDomain=" + this.taskToDomain + ", externalInputPayloadStoragePath='" + this.externalInputPayloadStoragePath + "', priority=" + this.priority + ", idempotencyKey='" + this.idempotencyKey + "', idempotencyStrategy=" + this.idempotencyStrategy + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StartWorkflowRequest request = (StartWorkflowRequest)object;
        return Objects.equals(this.name, request.name) && Objects.equals(this.version, request.version) && Objects.equals(this.correlationId, request.correlationId) && Objects.equals(this.input, request.input) && Objects.equals(this.taskToDomain, request.taskToDomain) && Objects.equals(this.externalInputPayloadStoragePath, request.externalInputPayloadStoragePath) && Objects.equals(this.priority, request.priority) && Objects.equals(this.idempotencyKey, request.idempotencyKey) && this.idempotencyStrategy == request.idempotencyStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.version, this.correlationId, this.input, this.taskToDomain, this.externalInputPayloadStoragePath, this.priority, this.idempotencyKey, this.idempotencyStrategy});
    }

    public String getName() {
        return this.name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public Map<String, String> getTaskToDomain() {
        return this.taskToDomain;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public IdempotencyStrategy getIdempotencyStrategy() {
        return this.idempotencyStrategy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setInput(Map<String, Object> input) {
        this.input = input;
    }

    public void setTaskToDomain(Map<String, String> taskToDomain) {
        this.taskToDomain = taskToDomain;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public void setIdempotencyStrategy(IdempotencyStrategy idempotencyStrategy) {
        this.idempotencyStrategy = idempotencyStrategy;
    }

    public static class Builder {
        private String name;
        private Integer version = 1;
        private String correlationId;
        private Map<String, Object> input = new HashMap<String, Object>();
        private Map<String, String> taskToDomain = new HashMap<String, String>();
        private String externalInputPayloadStoragePath;
        private Integer priority = 0;
        private String idempotencyKey;
        private IdempotencyStrategy idempotencyStrategy = IdempotencyStrategy.FAIL;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public Builder input(Map<String, Object> input) {
            this.input = input;
            return this;
        }

        public Builder taskToDomain(Map<String, String> taskToDomain) {
            this.taskToDomain = taskToDomain;
            return this;
        }

        public Builder externalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
            this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder idempotencyStrategy(IdempotencyStrategy idempotencyStrategy) {
            this.idempotencyStrategy = idempotencyStrategy;
            return this;
        }

        public StartWorkflowRequest build() {
            StartWorkflowRequest request = new StartWorkflowRequest();
            request.setName(this.name);
            request.setVersion(this.version);
            request.setCorrelationId(this.correlationId);
            request.setInput(this.input);
            request.setTaskToDomain(this.taskToDomain);
            request.setExternalInputPayloadStoragePath(this.externalInputPayloadStoragePath);
            request.setPriority(this.priority);
            request.setIdempotencyKey(this.idempotencyKey);
            request.setIdempotencyStrategy(this.idempotencyStrategy);
            return request;
        }
    }

    public static enum IdempotencyStrategy {
        NONE(0),
        FAIL(1),
        RETURN_EXISTING(2);

        private int code;

        private IdempotencyStrategy(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public boolean isNone() {
            return this == NONE;
        }
    }
}

