/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.metadata.workflow;

import cn.feiliu.taskflow.common.constraints.EmailConstraint;
import cn.feiliu.taskflow.common.constraints.TaskReferenceNameUniqueConstraint;
import cn.feiliu.taskflow.common.constraints.WorkflowNameConstraint;
import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@TaskReferenceNameUniqueConstraint
public class WorkflowDefinition {
    @WorkflowNameConstraint(message="Invalid workflow name")
    private String name;
    private String description;
    private int version = 1;
    @NotNull
    @NotEmpty(message="WorkflowTask list cannot be empty")
    private @NotNull @NotEmpty(message="WorkflowTask list cannot be empty") List<@Valid FlowTask> tasks = new LinkedList<FlowTask>();
    private List<String> inputParameters = new LinkedList<String>();
    private Map<String, Object> outputParameters = new HashMap<String, Object>();
    private String failureWorkflow;
    private boolean restartable = true;
    private boolean workflowStatusListenerEnabled = false;
    @EmailConstraint(message="ownerEmail should be valid email address")
    @Email(message="ownerEmail should be valid email address")
    private @Email(message="ownerEmail should be valid email address") String ownerEmail;
    private TimeoutPolicy timeoutPolicy = TimeoutPolicy.ALERT_ONLY;
    @NotNull
    private long timeoutSeconds;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Map<String, Object> inputTemplate = new HashMap<String, Object>();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(String name, int version) {
        return WorkflowDefinition.newBuilder().name(name).version(version);
    }

    public String key() {
        return WorkflowDefinition.getKey(this.name, this.version);
    }

    public static String getKey(String name, int version) {
        return name + "." + version;
    }

    public boolean containsType(String taskType) {
        return this.collectTasks().stream().anyMatch(t -> t.getType().equals(taskType));
    }

    public FlowTask getNextTask(String taskReferenceName) {
        FlowTask task;
        FlowTask workflowTask = this.getTaskByRefName(taskReferenceName);
        if (workflowTask != null && TaskType.TERMINATE.name().equals((Object)workflowTask.getType())) {
            return null;
        }
        Iterator<FlowTask> iterator = this.tasks.iterator();
        while (iterator.hasNext() && !(task = iterator.next()).getTaskReferenceName().equals(taskReferenceName)) {
            FlowTask nextTask = task.next(taskReferenceName, null);
            if (nextTask != null) {
                return nextTask;
            }
            if (TaskType.DO_WHILE.name().equals((Object)task.getType()) && !task.getTaskReferenceName().equals(taskReferenceName) && task.has(taskReferenceName)) {
                return null;
            }
            if (!task.has(taskReferenceName)) continue;
            break;
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public FlowTask getTaskByRefName(String taskReferenceName) {
        return this.collectTasks().stream().filter(workflowTask -> workflowTask.getTaskReferenceName().equals(taskReferenceName)).findFirst().orElse(null);
    }

    public List<FlowTask> collectTasks() {
        LinkedList<FlowTask> tasks = new LinkedList<FlowTask>();
        for (FlowTask workflowTask : this.tasks) {
            tasks.addAll(workflowTask.collectTasks());
        }
        return tasks;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setTasks(@NotNull List<@Valid FlowTask> tasks) {
        this.tasks = tasks;
    }

    public void setInputParameters(List<String> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public void setOutputParameters(Map<String, Object> outputParameters) {
        this.outputParameters = outputParameters;
    }

    public void setFailureWorkflow(String failureWorkflow) {
        this.failureWorkflow = failureWorkflow;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public void setWorkflowStatusListenerEnabled(boolean workflowStatusListenerEnabled) {
        this.workflowStatusListenerEnabled = workflowStatusListenerEnabled;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public void setTimeoutSeconds(@NotNull long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void setInputTemplate(Map<String, Object> inputTemplate) {
        this.inputTemplate = inputTemplate;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getVersion() {
        return this.version;
    }

    public @NotNull List<@Valid FlowTask> getTasks() {
        return this.tasks;
    }

    public List<String> getInputParameters() {
        return this.inputParameters;
    }

    public Map<String, Object> getOutputParameters() {
        return this.outputParameters;
    }

    public String getFailureWorkflow() {
        return this.failureWorkflow;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isWorkflowStatusListenerEnabled() {
        return this.workflowStatusListenerEnabled;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    @NotNull
    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, Object> getInputTemplate() {
        return this.inputTemplate;
    }

    public String toString() {
        return "WorkflowDefinition(name=" + this.getName() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", tasks=" + this.getTasks() + ", inputParameters=" + this.getInputParameters() + ", outputParameters=" + this.getOutputParameters() + ", failureWorkflow=" + this.getFailureWorkflow() + ", restartable=" + this.isRestartable() + ", workflowStatusListenerEnabled=" + this.isWorkflowStatusListenerEnabled() + ", ownerEmail=" + this.getOwnerEmail() + ", timeoutPolicy=" + this.getTimeoutPolicy() + ", timeoutSeconds=" + this.getTimeoutSeconds() + ", variables=" + this.getVariables() + ", inputTemplate=" + this.getInputTemplate() + ")";
    }

    public static class Builder {
        private String name;
        private String description;
        private int version = 1;
        private List<Task> tasks = new LinkedList<Task>();
        private List<String> inputParameters = new LinkedList<String>();
        private Map<String, Object> outputParameters = new HashMap<String, Object>();
        private String failureWorkflow;
        private boolean restartable = true;
        private boolean workflowStatusListenerEnabled = false;
        private String ownerEmail;
        private TimeoutPolicy timeoutPolicy = TimeoutPolicy.ALERT_ONLY;
        private long timeoutSeconds;
        private Map<String, Object> variables = new HashMap<String, Object>();
        private Map<String, Object> inputTemplate = new HashMap<String, Object>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder tasks(List<Task> tasks) {
            this.tasks = tasks;
            return this;
        }

        public Builder addTask(Task task) {
            this.tasks.add(task);
            return this;
        }

        public Builder inputParameters(List<String> inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public Builder outputParameters(Map<String, Object> outputParameters) {
            this.outputParameters = outputParameters;
            return this;
        }

        public Builder failureWorkflow(String failureWorkflow) {
            this.failureWorkflow = failureWorkflow;
            return this;
        }

        public Builder restartable(boolean restartable) {
            this.restartable = restartable;
            return this;
        }

        public Builder workflowStatusListenerEnabled(boolean workflowStatusListenerEnabled) {
            this.workflowStatusListenerEnabled = workflowStatusListenerEnabled;
            return this;
        }

        public Builder ownerEmail(String ownerEmail) {
            this.ownerEmail = ownerEmail;
            return this;
        }

        public Builder timeoutPolicy(TimeoutPolicy timeoutPolicy) {
            this.timeoutPolicy = timeoutPolicy;
            return this;
        }

        public Builder timeoutSeconds(long timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public Builder inputTemplate(Map<String, Object> inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public WorkflowDefinition build() {
            WorkflowDefinition workflowDefinition = new WorkflowDefinition();
            workflowDefinition.name = this.name;
            workflowDefinition.description = this.description;
            workflowDefinition.version = this.version;
            ArrayList<FlowTask> flowTasks = new ArrayList<FlowTask>();
            for (Task task : this.tasks) {
                flowTasks.addAll(task.getWorkflowDefTasks());
            }
            workflowDefinition.tasks = flowTasks;
            workflowDefinition.inputParameters = this.inputParameters;
            workflowDefinition.outputParameters = this.outputParameters;
            workflowDefinition.failureWorkflow = this.failureWorkflow;
            workflowDefinition.restartable = this.restartable;
            workflowDefinition.workflowStatusListenerEnabled = this.workflowStatusListenerEnabled;
            workflowDefinition.ownerEmail = this.ownerEmail;
            workflowDefinition.timeoutPolicy = this.timeoutPolicy;
            workflowDefinition.timeoutSeconds = this.timeoutSeconds;
            workflowDefinition.variables = this.variables;
            workflowDefinition.inputTemplate = this.inputTemplate;
            return workflowDefinition;
        }
    }

    public static enum TimeoutPolicy {
        TIME_OUT_WF,
        ALERT_ONLY;

    }
}

