/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.run;

import cn.feiliu.taskflow.common.metadata.tasks.ExecutingTask;
import cn.feiliu.taskflow.common.metadata.workflow.WorkflowDefinition;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.StringUtils;

public class ExecutingWorkflow {
    private WorkflowStatus status = WorkflowStatus.RUNNING;
    private long startTime;
    private long endTime;
    private String workflowId;
    private String parentWorkflowId;
    private String parentWorkflowTaskId;
    private List<ExecutingTask> tasks = new LinkedList<ExecutingTask>();
    private Map<String, Object> input = new HashMap<String, Object>();
    private Map<String, Object> output = new HashMap<String, Object>();
    private String correlationId;
    private String reRunFromWorkflowId;
    private String reasonForIncompletion;
    private String event;
    private Map<String, String> taskToDomain = new HashMap<String, String>();
    private Set<String> failedReferenceTaskNames = new HashSet<String>();
    private WorkflowDefinition workflowDefinition;
    private String externalInputPayloadStoragePath;
    private String externalOutputPayloadStoragePath;
    @Min(value=0L, message="workflow priority: ${validatedValue} should be minimum {value}")
    @Max(value=99L, message="workflow priority: ${validatedValue} should be maximum {value}")
    private @Min(value=0L, message="workflow priority: ${validatedValue} should be minimum {value}") @Max(value=99L, message="workflow priority: ${validatedValue} should be maximum {value}") int priority;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private long lastRetriedTime;

    public void setPriority(int priority) {
        if (priority < 0 || priority > 99) {
            throw new IllegalArgumentException("priority MUST be between 0 and 99 (inclusive)");
        }
        this.priority = priority;
    }

    public String getWorkflowName() {
        Preconditions.checkNotNull((Object)this.workflowDefinition, (Object)"Workflow definition is null");
        return this.workflowDefinition.getName();
    }

    public int getWorkflowVersion() {
        Preconditions.checkNotNull((Object)this.workflowDefinition, (Object)"Workflow definition is null");
        return this.workflowDefinition.getVersion();
    }

    public boolean hasParent() {
        return StringUtils.isNotEmpty((CharSequence)this.parentWorkflowId);
    }

    public ExecutingTask getTaskByRefName(String refName) {
        if (refName == null) {
            throw new RuntimeException("refName passed is null.  Check the workflow execution.  For dynamic tasks, make sure referenceTaskName is set to a not null value");
        }
        LinkedList<ExecutingTask> found = new LinkedList<ExecutingTask>();
        for (ExecutingTask t : this.tasks) {
            if (t.getReferenceTaskName() == null) {
                throw new RuntimeException("Task " + t.getTaskDefName() + ", seq=" + t.getSeq() + " does not have reference name specified.");
            }
            if (!t.getReferenceTaskName().equals(refName)) continue;
            found.add(t);
        }
        if (found.isEmpty()) {
            return null;
        }
        return (ExecutingTask)found.getLast();
    }

    public ExecutingWorkflow copy() {
        ExecutingWorkflow copy = new ExecutingWorkflow();
        copy.setInput(this.input);
        copy.setOutput(this.output);
        copy.setStatus(this.status);
        copy.setWorkflowId(this.workflowId);
        copy.setParentWorkflowId(this.parentWorkflowId);
        copy.setParentWorkflowTaskId(this.parentWorkflowTaskId);
        copy.setReRunFromWorkflowId(this.reRunFromWorkflowId);
        copy.setCorrelationId(this.correlationId);
        copy.setEvent(this.event);
        copy.setReasonForIncompletion(this.reasonForIncompletion);
        copy.setWorkflowDefinition(this.workflowDefinition);
        copy.setPriority(this.priority);
        copy.setTasks(this.tasks.stream().map(ExecutingTask::deepCopy).collect(Collectors.toList()));
        copy.setVariables(this.variables);
        copy.setEndTime(this.endTime);
        copy.setLastRetriedTime(this.lastRetriedTime);
        copy.setTaskToDomain(this.taskToDomain);
        copy.setFailedReferenceTaskNames(this.failedReferenceTaskNames);
        copy.setExternalInputPayloadStoragePath(this.externalInputPayloadStoragePath);
        copy.setExternalOutputPayloadStoragePath(this.externalOutputPayloadStoragePath);
        return copy;
    }

    public String toString() {
        String name = this.workflowDefinition != null ? this.workflowDefinition.getName() : null;
        Integer version = this.workflowDefinition != null ? Integer.valueOf(this.workflowDefinition.getVersion()) : null;
        return String.format("%s.%s/%s.%s", new Object[]{name, version, this.workflowId, this.status});
    }

    public String toShortString() {
        String name = this.workflowDefinition != null ? this.workflowDefinition.getName() : null;
        Integer version = this.workflowDefinition != null ? Integer.valueOf(this.workflowDefinition.getVersion()) : null;
        return String.format("%s.%s/%s", name, version, this.workflowId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutingWorkflow workflow = (ExecutingWorkflow)o;
        return this.getEndTime() == workflow.getEndTime() && this.getWorkflowVersion() == workflow.getWorkflowVersion() && this.getStatus() == workflow.getStatus() && Objects.equals(this.getWorkflowId(), workflow.getWorkflowId()) && Objects.equals(this.getParentWorkflowId(), workflow.getParentWorkflowId()) && Objects.equals(this.getParentWorkflowTaskId(), workflow.getParentWorkflowTaskId()) && Objects.equals(this.getTasks(), workflow.getTasks()) && Objects.equals(this.getInput(), workflow.getInput()) && Objects.equals(this.getOutput(), workflow.getOutput()) && Objects.equals(this.getWorkflowName(), workflow.getWorkflowName()) && Objects.equals(this.getCorrelationId(), workflow.getCorrelationId()) && Objects.equals(this.getReRunFromWorkflowId(), workflow.getReRunFromWorkflowId()) && Objects.equals(this.getReasonForIncompletion(), workflow.getReasonForIncompletion()) && Objects.equals(this.getEvent(), workflow.getEvent()) && Objects.equals(this.getTaskToDomain(), workflow.getTaskToDomain()) && Objects.equals(this.getFailedReferenceTaskNames(), workflow.getFailedReferenceTaskNames()) && Objects.equals(this.getExternalInputPayloadStoragePath(), workflow.getExternalInputPayloadStoragePath()) && Objects.equals(this.getExternalOutputPayloadStoragePath(), workflow.getExternalOutputPayloadStoragePath()) && Objects.equals(this.getPriority(), workflow.getPriority()) && Objects.equals(this.getWorkflowDefinition(), workflow.getWorkflowDefinition()) && Objects.equals(this.getVariables(), workflow.getVariables()) && Objects.equals(this.getLastRetriedTime(), workflow.getLastRetriedTime());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getStatus(), this.getEndTime(), this.getWorkflowId(), this.getParentWorkflowId(), this.getParentWorkflowTaskId(), this.getTasks(), this.getInput(), this.getOutput(), this.getWorkflowName(), this.getWorkflowVersion(), this.getCorrelationId(), this.getReRunFromWorkflowId(), this.getReasonForIncompletion(), this.getEvent(), this.getTaskToDomain(), this.getFailedReferenceTaskNames(), this.getWorkflowDefinition(), this.getExternalInputPayloadStoragePath(), this.getExternalOutputPayloadStoragePath(), this.getPriority(), this.getVariables(), this.getLastRetriedTime()});
    }

    public WorkflowStatus getStatus() {
        return this.status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getParentWorkflowId() {
        return this.parentWorkflowId;
    }

    public String getParentWorkflowTaskId() {
        return this.parentWorkflowTaskId;
    }

    public List<ExecutingTask> getTasks() {
        return this.tasks;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public Map<String, Object> getOutput() {
        return this.output;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getReRunFromWorkflowId() {
        return this.reRunFromWorkflowId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public String getEvent() {
        return this.event;
    }

    public Map<String, String> getTaskToDomain() {
        return this.taskToDomain;
    }

    public Set<String> getFailedReferenceTaskNames() {
        return this.failedReferenceTaskNames;
    }

    public WorkflowDefinition getWorkflowDefinition() {
        return this.workflowDefinition;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public int getPriority() {
        return this.priority;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public long getLastRetriedTime() {
        return this.lastRetriedTime;
    }

    public void setStatus(WorkflowStatus status) {
        this.status = status;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public void setParentWorkflowId(String parentWorkflowId) {
        this.parentWorkflowId = parentWorkflowId;
    }

    public void setParentWorkflowTaskId(String parentWorkflowTaskId) {
        this.parentWorkflowTaskId = parentWorkflowTaskId;
    }

    public void setTasks(List<ExecutingTask> tasks) {
        this.tasks = tasks;
    }

    public void setInput(Map<String, Object> input) {
        this.input = input;
    }

    public void setOutput(Map<String, Object> output) {
        this.output = output;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setReRunFromWorkflowId(String reRunFromWorkflowId) {
        this.reRunFromWorkflowId = reRunFromWorkflowId;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setTaskToDomain(Map<String, String> taskToDomain) {
        this.taskToDomain = taskToDomain;
    }

    public void setFailedReferenceTaskNames(Set<String> failedReferenceTaskNames) {
        this.failedReferenceTaskNames = failedReferenceTaskNames;
    }

    public void setWorkflowDefinition(WorkflowDefinition workflowDefinition) {
        this.workflowDefinition = workflowDefinition;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void setLastRetriedTime(long lastRetriedTime) {
        this.lastRetriedTime = lastRetriedTime;
    }

    public static enum WorkflowStatus {
        RUNNING(false, false),
        COMPLETED(true, true),
        FAILED(true, false),
        TIMED_OUT(true, false),
        TERMINATED(true, false),
        PAUSED(false, true);

        private final boolean terminal;
        private final boolean successful;

        private WorkflowStatus(boolean terminal, boolean successful) {
            this.terminal = terminal;
            this.successful = successful;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

