/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.utils;

import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.common.metadata.workflow.WorkflowDefinition;
import cn.feiliu.taskflow.common.utils.EnvUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConstraintParamUtil {
    public static List<String> validateInputParam(Map<String, Object> input, String taskName, WorkflowDefinition workflow) {
        ArrayList<String> errorList = new ArrayList<String>();
        for (Map.Entry<String, Object> e : input.entrySet()) {
            Object value = e.getValue();
            if (value instanceof String) {
                errorList.addAll(ConstraintParamUtil.extractParamPathComponentsFromString(e.getKey(), value.toString(), taskName, workflow));
                continue;
            }
            if (value instanceof Map) {
                errorList.addAll(ConstraintParamUtil.validateInputParam((Map)value, taskName, workflow));
                continue;
            }
            if (value instanceof List) {
                errorList.addAll(ConstraintParamUtil.extractListInputParam(e.getKey(), (List)value, taskName, workflow));
                continue;
            }
            e.setValue(value);
        }
        return errorList;
    }

    private static List<String> extractListInputParam(String key, List<?> values, String taskName, WorkflowDefinition workflow) {
        ArrayList<String> errorList = new ArrayList<String>();
        for (Object listVal : values) {
            if (listVal instanceof String) {
                errorList.addAll(ConstraintParamUtil.extractParamPathComponentsFromString(key, listVal.toString(), taskName, workflow));
                continue;
            }
            if (listVal instanceof Map) {
                errorList.addAll(ConstraintParamUtil.validateInputParam((Map)listVal, taskName, workflow));
                continue;
            }
            if (!(listVal instanceof List)) continue;
            errorList.addAll(ConstraintParamUtil.extractListInputParam(key, (List)listVal, taskName, workflow));
        }
        return errorList;
    }

    private static List<String> extractParamPathComponentsFromString(String key, String value, String taskName, WorkflowDefinition workflow) {
        String[] values;
        ArrayList<String> errorList = new ArrayList<String>();
        if (value == null) {
            String message = String.format("key: %s input parameter value: is null", key);
            errorList.add(message);
            return errorList;
        }
        for (String s : values = value.split("(?=(?<!\\$)\\$\\{)|(?<=\\})")) {
            FlowTask task;
            if (!s.startsWith("${") || !s.endsWith("}")) continue;
            String paramPath = s.substring(2, s.length() - 1);
            if (StringUtils.containsWhitespace((CharSequence)paramPath)) {
                String message = String.format("key: %s input parameter value: %s is not valid", key, paramPath);
                errorList.add(message);
                continue;
            }
            if (EnvUtils.isEnvironmentVariable(paramPath)) {
                String sysValue;
                boolean isPredefinedEnum = false;
                for (EnvUtils.SystemParameters systemParameters : EnvUtils.SystemParameters.values()) {
                    if (!systemParameters.name().equals(paramPath)) continue;
                    isPredefinedEnum = true;
                    break;
                }
                if (isPredefinedEnum || (sysValue = EnvUtils.getSystemParametersValue(paramPath, "")) != null) continue;
                String errorMessage = String.format("environment variable: %s for given task: %s input value: %s of input parameter: %s is not valid", paramPath, taskName, key, value);
                errorList.add(errorMessage);
                continue;
            }
            String[] components = paramPath.split("\\.");
            if ("workflow".equals(components[0]) || (task = workflow.getTaskByRefName(components[0])) != null) continue;
            String message = String.format("taskReferenceName: %s for given task: %s input value: %s of input parameter: %s is not defined in workflow definition.", components[0], taskName, key, value);
            errorList.add(message);
        }
        return errorList;
    }
}

