/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class ExternalServiceFactory {
    private static final Map<Class<?>, Collection<Object>> SERVICES = new ConcurrentHashMap();

    public static void register(Class<?> serviceInterface) {
        if (!SERVICES.containsKey(serviceInterface)) {
            SERVICES.put(serviceInterface, ExternalServiceFactory.load(serviceInterface));
        }
    }

    public static <T> Collection<T> getServiceInstances(Class<T> serviceInterface) {
        return ExternalServiceFactory.createNewServiceInstances(serviceInterface);
    }

    public static <T> Optional<T> getFirstServiceInstance(Class<T> serviceInterface) {
        Collection<T> collection = ExternalServiceFactory.createNewServiceInstances(serviceInterface);
        Iterator<T> iterator = collection.iterator();
        if (iterator.hasNext()) {
            return Optional.ofNullable(iterator.next());
        }
        return Optional.empty();
    }

    private static <T> Collection<Object> load(Class<T> serviceInterface) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (T each : ServiceLoader.load(serviceInterface)) {
            result.add(each);
        }
        return result;
    }

    private static <T> Collection<T> createNewServiceInstances(Class<T> serviceInterface) {
        if (!SERVICES.containsKey(serviceInterface)) {
            return Collections.emptyList();
        }
        Collection<Object> services = SERVICES.get(serviceInterface);
        if (services.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        for (Object each : services) {
            try {
                result.add(each.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

