/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.utils;

import cn.feiliu.taskflow.common.utils.TaskflowUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JsValidator {
    private static final Set<String> JS_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "arguments", "await", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "eval", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield"));

    public static boolean isValidJsVariableName(String name) {
        if (name == null || name.isEmpty() || Character.isDigit(name.charAt(0))) {
            return false;
        }
        if (JS_KEYWORDS.contains(name)) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$') continue;
            return false;
        }
        return true;
    }

    public static void assertVariableName(String taskReferenceName) {
        if (!JsValidator.isValidJsVariableName(taskReferenceName)) {
            throw new IllegalArgumentException(TaskflowUtils.f("The taskReferenceName: '%s' parameter is invalid", taskReferenceName));
        }
    }
}

