/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.utils;

import cn.feiliu.taskflow.sdk.worker.Worker;
import cn.feiliu.taskflow.sdk.workflow.executor.task.AnnotatedWorker;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskflowUtils {
    private static final Logger log = LoggerFactory.getLogger(TaskflowUtils.class);

    public static String dumpStackTrace(Throwable t) {
        StackTraceElement stackTraceElement;
        String className;
        StringBuilder stackTrace = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n && !(className = (stackTraceElement = stackTraceElementArray[i]).getClassName()).startsWith("jdk.") && !className.startsWith(AnnotatedWorker.class.getName()); ++i) {
            stackTrace.append(stackTraceElement);
            stackTrace.append("\n");
        }
        return stackTrace.toString();
    }

    public static String dumpFullStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String f(String format, Object ... args) {
        return String.format(format, args);
    }

    public static void blockedWait(List<Future<?>> futures, int timeoutMs) {
        long startTime = System.currentTimeMillis();
        for (Future<?> future : futures) {
            try {
                long remainingTime = (long)timeoutMs - (System.currentTimeMillis() - startTime);
                if (remainingTime > 0L) {
                    future.get(remainingTime, TimeUnit.MILLISECONDS);
                    continue;
                }
                future.cancel(true);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to wait for futures", e);
            }
        }
    }

    public static void retryOperation(Runnable task, int count, String opName) {
        int index = 0;
        while (true) {
            try {
                task.run();
                return;
            }
            catch (Exception e) {
                log.error("Error executing " + opName, (Throwable)e);
                Uninterruptibles.sleepUninterruptibly((long)(500L * (long)(count + 1)), (TimeUnit)TimeUnit.MILLISECONDS);
                if (++index < count) continue;
                throw new RuntimeException("Exhausted retries performing " + opName);
            }
            break;
        }
    }

    public static int getReasonableTimeout(Worker worker) {
        int timeout = worker.getBatchPollTimeoutInMS();
        if (timeout <= 100) {
            return 100;
        }
        if (timeout > 1000) {
            return 1000;
        }
        return timeout;
    }
}

