/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.common.utils;

import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.common.metadata.workflow.WorkflowDefinition;
import cn.feiliu.taskflow.common.utils.ConstraintParamUtil;
import cn.feiliu.taskflow.common.utils.TaskflowUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static final Logger log = LoggerFactory.getLogger(Validator.class);
    private static final String EMAIL_PATTERN = "^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    private static final Pattern pattern = Pattern.compile("^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$");

    public static boolean isEmail(String email) {
        if (StringUtils.isNotBlank((CharSequence)email) && email.length() <= 128) {
            return pattern.matcher(email).matches();
        }
        return false;
    }

    public static boolean isValidWorkflowDefName(String name) {
        return name != null && name.matches("^[a-zA-Z0-9_-]{1,64}$");
    }

    public static boolean isValidWorkflowVersion(Integer version) {
        return version != null && version >= 1;
    }

    public static boolean isExpression(Object value) {
        if (value != null && value instanceof String) {
            String str = ((String)value).trim();
            return str.startsWith("${") && str.endsWith("}");
        }
        return false;
    }

    public static boolean isValidTaskRefName(String taskRefName) {
        String regex = "^[a-zA-Z0-9_]{1,64}$";
        return taskRefName != null && taskRefName.matches(regex);
    }

    public static void assertTaskRefName(String taskRefName) {
        if (!Validator.isValidTaskRefName(taskRefName)) {
            throw new IllegalArgumentException(TaskflowUtils.f("The taskReferenceName: '%s' parameter is invalid", taskRefName));
        }
    }

    public static boolean isValidTaskName(String taskName) {
        String regex = "^[a-zA-Z0-9_]{1,64}$";
        return taskName != null && taskName.matches(regex);
    }

    public static void assertTaskName(String taskRefName) {
        if (!Validator.isValidTaskName(taskRefName)) {
            throw new IllegalArgumentException(TaskflowUtils.f("The taskName: '%s' parameter is invalid", taskRefName));
        }
    }

    private static List<String> verifyTaskRefNameUniqueness(WorkflowDefinition workflowDef) {
        Objects.requireNonNull(workflowDef, "workflowDef cannot be null");
        ArrayList<String> errors = new ArrayList<String>();
        HashSet taskReferences = new HashSet();
        workflowDef.collectTasks().forEach(task -> {
            if (!Validator.isValidTaskName(task.getName())) {
                errors.add("Invalid task name: " + task.getName());
            }
            if (!Validator.isValidTaskRefName(task.getTaskReferenceName())) {
                errors.add("Invalid taskReferenceName: " + task.getTaskReferenceName());
            }
            if (!taskReferences.add(task.getTaskReferenceName())) {
                errors.add(TaskflowUtils.f("taskReferenceName: %s should be unique across tasks for a given workflowDefinition: %s", task.getTaskReferenceName(), workflowDef.getName()));
            }
        });
        return errors;
    }

    public static List<String> verifyWorkflowDef(WorkflowDefinition workflowDef) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!Validator.isValidWorkflowDefName(workflowDef.getName())) {
            errors.add("Invalid workflow name");
        }
        if (!Validator.isValidWorkflowVersion(workflowDef.getVersion())) {
            errors.add("Invalid workflow version");
        }
        if (workflowDef.getTasks().isEmpty()) {
            errors.add("tasks cannot be empty");
        }
        errors.addAll(Validator.verifyTaskRefNameUniqueness(workflowDef));
        errors.addAll(Validator.verifyTaskInputParameters(workflowDef));
        return errors;
    }

    private static List<String> verifyTaskInputParameters(WorkflowDefinition workflow) {
        LinkedList<String> errors = new LinkedList<String>();
        for (FlowTask task : workflow.getTasks()) {
            if (!Validator.isValidTaskName(task.getName())) {
                errors.add("Invalid task name: " + task.getName());
            }
            errors.addAll(ConstraintParamUtil.validateInputParam(task.getInputParameters(), task.getName(), workflow));
        }
        return errors;
    }
}

