/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.expression;

import cn.feiliu.taskflow.expression.AbstractPathExpression;
import java.util.List;
import java.util.Objects;

public class InputExpression
extends AbstractPathExpression {
    private final List<String> parts;

    public InputExpression(List<String> parts) {
        Objects.requireNonNull(parts, "parts is null");
        parts.add("input");
        this.parts = parts;
    }

    public InputExpression get(String field) {
        this.parts.add(field);
        return this;
    }

    public InputExpression path(String ... paths) {
        for (String path : paths) {
            this.parts.add(path);
        }
        return this;
    }

    public InputExpression get() {
        return this;
    }

    @Override
    public String getExpression() {
        return super.getExpression(this.parts);
    }

    public InputExpression index(int i) {
        int index = this.parts.size() - 1;
        this.parts.set(index, this.parts.get(index) + "[" + i + "]");
        return this;
    }
}

