/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.expression;

import cn.feiliu.taskflow.expression.Expr;
import cn.feiliu.taskflow.expression.PathExpression;
import java.util.Objects;

public class Pair {
    private final String name;
    private PathExpression value;

    private Pair(String taskParameterName) {
        this.name = Objects.requireNonNull(taskParameterName);
    }

    public static Pair of(String taskParameterName) {
        return new Pair(taskParameterName);
    }

    public String[] fromWorkflow() {
        this.value = Expr.workflow().input();
        return this.getResult();
    }

    public String[] fromWorkflow(String ... paths) {
        this.value = Expr.workflow().input.path(paths);
        return this.getResult();
    }

    public String[] fromTaskOutput(String taskRefName, String ... paths) {
        this.value = Expr.task((String)taskRefName).output.path(paths);
        return this.getResult();
    }

    public String[] fromTaskOutput(String taskRefName, String resultName) {
        this.value = Expr.task((String)taskRefName).output.get(resultName);
        return this.getResult();
    }

    public String[] fromTaskOutput(String taskRefName) {
        this.value = Expr.task((String)taskRefName).output;
        return this.getResult();
    }

    public String[] fromTaskInput(String taskRefName) {
        this.value = Expr.task((String)taskRefName).input;
        return this.getResult();
    }

    public String[] fromTaskInput(String taskRefName, String fieldName) {
        this.value = Expr.task((String)taskRefName).input.get(fieldName);
        return this.getResult();
    }

    public String[] fromTaskInput(String taskRefName, String ... paths) {
        this.value = Expr.task((String)taskRefName).input.path(paths);
        return this.getResult();
    }

    private String[] getResult() {
        return new String[]{this.name, this.value.getExpression()};
    }

    public String getName() {
        return this.name;
    }

    public PathExpression getValue() {
        return this.value;
    }
}

