/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.mapper;

import cn.feiliu.taskflow.mapper.BaseMapper;
import cn.feiliu.taskflow.proto.JsonMapPb;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.NullValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class JsonMapMapper
extends BaseMapper {
    public static final JsonMapMapper INSTANCE = new JsonMapMapper();

    JsonMapMapper() {
    }

    public static JsonMapMapper getInstance() {
        return new JsonMapMapper();
    }

    public Map<String, Object> convertToJavaMap(JsonMapPb.JsonMap inputDataMap) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        inputDataMap.getFieldsMap().forEach((k, jv) -> data.put((String)k, this.fromProtoJsonValue((JsonMapPb.JsonValue)jv)));
        return data;
    }

    public JsonMapPb.JsonMap convertToJsonMap(Map<String, Object> map) {
        if (map == null) {
            return JsonMapPb.JsonMap.newBuilder().build();
        }
        JsonMapPb.JsonMap.Builder jsonMap = JsonMapPb.JsonMap.newBuilder();
        map.forEach((k, v) -> jsonMap.putFields(k, this.toProtoJsonValue(v)));
        return jsonMap.build();
    }

    protected Object fromProtoJsonValue(JsonMapPb.JsonValue any) {
        switch (any.getKindCase()) {
            case NULL_VALUE: {
                return null;
            }
            case INT_VALUE: {
                return any.getIntValue();
            }
            case LONG_VALUE: {
                return any.getLongValue();
            }
            case DOUBLE_VALUE: {
                return any.getDoubleValue();
            }
            case STRING_VALUE: {
                return any.getStringValue();
            }
            case BOOL_VALUE: {
                return any.getBoolValue();
            }
            case STRUCT_VALUE: {
                return this.convertToJavaMap(any.getStructValue());
            }
            case LIST_VALUE: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (JsonMapPb.JsonValue val : any.getListValue().getValuesList()) {
                    list.add(this.fromProtoJsonValue(val));
                }
                return list;
            }
        }
        throw new ClassCastException("unset Value element: " + any);
    }

    protected JsonMapPb.JsonValue toProtoJsonValue(Object val) {
        JsonMapPb.JsonValue.Builder builder = JsonMapPb.JsonValue.newBuilder();
        this.setProtoJsonValue(builder, val);
        return builder.build();
    }

    private void setProtoJsonValue(JsonMapPb.JsonValue.Builder builder, Object val) {
        if (val == null) {
            builder.setNullValue(NullValue.NULL_VALUE);
        } else if (val instanceof Boolean) {
            builder.setBoolValue(((Boolean)val).booleanValue());
        } else if (val instanceof Double) {
            builder.setDoubleValue(((Double)val).doubleValue());
        } else if (val instanceof Float) {
            builder.setDoubleValue((double)((Float)val).floatValue());
        } else if (val instanceof Integer) {
            builder.setIntValue(((Integer)val).intValue());
        } else if (val instanceof Long) {
            builder.setLongValue(((Long)val).longValue());
        } else if (val instanceof Short) {
            builder.setIntValue((int)((Short)val).shortValue());
        } else if (val instanceof String) {
            builder.setStringValue((String)val);
        } else if (val instanceof Map) {
            builder.setStructValue(this.convertToJsonMap((Map)val));
        } else if (val instanceof List) {
            JsonMapPb.JsonList.Builder list = JsonMapPb.JsonList.newBuilder();
            for (Object obj : (List)val) {
                list.addValues(this.toProtoJsonValue(obj));
            }
            builder.setListValue(list.build());
        } else if (val instanceof JsonNode) {
            this.setProtoJsonValue(builder, this.getValueFromJsonNode((JsonNode)val));
        } else {
            Map<String, Object> map = this.strongMap(val);
            builder.setStructValue(this.convertToJsonMap(map));
        }
    }

    private Object getValueFromJsonNode(JsonNode val) {
        if (val instanceof IntNode) {
            return val.asInt();
        }
        if (val instanceof LongNode) {
            return val.asLong();
        }
        if (val instanceof TextNode) {
            return val.asText();
        }
        if (val instanceof BooleanNode) {
            return val.asBoolean();
        }
        if (val instanceof FloatNode) {
            return val.asDouble();
        }
        if (val instanceof DoubleNode) {
            return val.asDouble();
        }
        if (val instanceof ObjectNode) {
            return this.strongMap(val);
        }
        if (val instanceof ArrayNode) {
            return this.strongList(val);
        }
        if (val instanceof NullNode) {
            return null;
        }
        throw new RuntimeException(String.format("Cannot convert JsonNode of type %s to mapper", val.getClass()));
    }
}

