/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.mapper;

import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ProtoValueMapper {
    ProtoValueMapper() {
    }

    public static Value toProto(Object val) {
        Value.Builder builder = Value.newBuilder();
        if (val == null) {
            builder.setNullValue(NullValue.NULL_VALUE);
        } else if (val instanceof Boolean) {
            builder.setBoolValue(((Boolean)val).booleanValue());
        } else if (val instanceof Double) {
            builder.setNumberValue(((Double)val).doubleValue());
        } else if (val instanceof Integer) {
            builder.setNumberValue((double)((Integer)val).intValue());
        } else if (val instanceof String) {
            builder.setStringValue((String)val);
        } else if (val instanceof Map) {
            Map map = (Map)val;
            Struct.Builder struct = Struct.newBuilder();
            for (Map.Entry pair : map.entrySet()) {
                struct.putFields((String)pair.getKey(), ProtoValueMapper.toProto(pair.getValue()));
            }
            builder.setStructValue(struct.build());
        } else if (val instanceof List) {
            ListValue.Builder list = ListValue.newBuilder();
            for (Object obj : (List)val) {
                list.addValues(ProtoValueMapper.toProto(obj));
            }
            builder.setListValue(list.build());
        } else {
            throw new ClassCastException("cannot map to Value type: " + val);
        }
        return builder.build();
    }

    public static Object fromProto(Value any) {
        switch (any.getKindCase()) {
            case NULL_VALUE: {
                return null;
            }
            case BOOL_VALUE: {
                return any.getBoolValue();
            }
            case NUMBER_VALUE: {
                return any.getNumberValue();
            }
            case STRING_VALUE: {
                return any.getStringValue();
            }
            case STRUCT_VALUE: {
                Struct struct = any.getStructValue();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Map.Entry pair : struct.getFieldsMap().entrySet()) {
                    map.put((String)pair.getKey(), ProtoValueMapper.fromProto((Value)pair.getValue()));
                }
                return map;
            }
            case LIST_VALUE: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Value val : any.getListValue().getValuesList()) {
                    list.add(ProtoValueMapper.fromProto(val));
                }
                return list;
            }
        }
        throw new ClassCastException("unset Value element: " + any);
    }
}

