/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.mapper;

import cn.feiliu.taskflow.mapper.BaseMapper;
import cn.feiliu.taskflow.mapper.MapperFactory;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ValueMapper
extends BaseMapper {
    private MapperFactory mapperFactory;

    public static ValueMapper getInstance() {
        return new ValueMapper();
    }

    public Value toProto(Object val) {
        Value.Builder builder = Value.newBuilder();
        if (val == null) {
            builder.setNullValue(NullValue.NULL_VALUE);
        } else if (val instanceof Boolean) {
            builder.setBoolValue(((Boolean)val).booleanValue());
        } else if (val instanceof Float) {
            builder.setNumberValue((double)((Float)val).floatValue());
        } else if (val instanceof Double) {
            builder.setNumberValue(((Double)val).doubleValue());
        } else if (val instanceof Long) {
            builder.setNumberValue((double)((Long)val).longValue());
        } else if (val instanceof Integer) {
            builder.setNumberValue((double)((Integer)val).intValue());
        } else if (val instanceof String) {
            builder.setStringValue((String)val);
        } else if (val instanceof Map) {
            builder.setStructValue(this.convertStruct((Map)val));
        } else if (val instanceof List) {
            builder.setListValue(this.convertList((List)val));
        } else if (val.getClass().isArray()) {
            builder.setListValue(this.convertList((Object[])val));
        } else {
            return this.toProto(this.strongMap(val));
        }
        return builder.build();
    }

    private Struct convertStruct(Map<String, Object> map) {
        Struct.Builder struct = Struct.newBuilder();
        for (Map.Entry<String, Object> pair : map.entrySet()) {
            struct.putFields(pair.getKey(), this.toProto(pair.getValue()));
        }
        return struct.build();
    }

    private ListValue convertList(List<?> list) {
        ListValue.Builder builder = ListValue.newBuilder();
        for (Object object : list) {
            builder.addValues(this.toProto(object));
        }
        return builder.build();
    }

    private ListValue convertList(Object[] array) {
        ListValue.Builder list = ListValue.newBuilder();
        for (Object object : array) {
            list.addValues(this.toProto(object));
        }
        return list.build();
    }

    public Object fromProto(Value any) {
        switch (any.getKindCase()) {
            case NULL_VALUE: {
                return null;
            }
            case BOOL_VALUE: {
                return any.getBoolValue();
            }
            case NUMBER_VALUE: {
                return any.getNumberValue();
            }
            case STRING_VALUE: {
                return any.getStringValue();
            }
            case STRUCT_VALUE: {
                Struct struct = any.getStructValue();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Map.Entry pair : struct.getFieldsMap().entrySet()) {
                    map.put((String)pair.getKey(), this.fromProto((Value)pair.getValue()));
                }
                return map;
            }
            case LIST_VALUE: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Value val : any.getListValue().getValuesList()) {
                    list.add(this.fromProto(val));
                }
                return list;
            }
        }
        throw new ClassCastException("unset Value element: " + any);
    }

    private ValueMapper() {
    }

    public static ValueMapper of() {
        return new ValueMapper();
    }

    public MapperFactory getMapperFactory() {
        return this.mapperFactory;
    }

    public void setMapperFactory(MapperFactory mapperFactory) {
        this.mapperFactory = mapperFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueMapper)) {
            return false;
        }
        ValueMapper other = (ValueMapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MapperFactory this$mapperFactory = this.getMapperFactory();
        MapperFactory other$mapperFactory = other.getMapperFactory();
        return !(this$mapperFactory == null ? other$mapperFactory != null : !this$mapperFactory.equals(other$mapperFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValueMapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MapperFactory $mapperFactory = this.getMapperFactory();
        result = result * 59 + ($mapperFactory == null ? 43 : $mapperFactory.hashCode());
        return result;
    }

    public String toString() {
        return "ValueMapper(mapperFactory=" + this.getMapperFactory() + ")";
    }
}

