/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.open;

import cn.feiliu.taskflow.open.TaskflowErrorInformation;
import cn.feiliu.taskflow.open.exceptions.ApiException;
import cn.feiliu.taskflow.open.exceptions.ConflictException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class ApiResponse<T> {
    private T data;
    private int code = 200;
    private String msg = "ok";
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private TaskflowErrorInformation engineErrorResponse;

    public ApiResponse(T data) {
        this.data = data;
    }

    public ApiResponse(int code, Map<String, List<String>> headers, T data) {
        this.code = code;
        this.headers = headers;
        this.data = data;
    }

    public static ApiResponse noContent() {
        return ApiResponse.of(null, 204, "No Content");
    }

    public static <T> ApiResponse<T> ok(@Nullable T body) {
        return new ApiResponse<T>(body);
    }

    public static ApiResponse of(Map<String, List<String>> headers, int code, String reason) {
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.code = code;
        apiResponse.msg = reason;
        apiResponse.setHeaders(headers);
        return apiResponse;
    }

    public static ApiResponse of(Map<String, List<String>> headers, TaskflowErrorInformation engineErrorResponse, int code, String reason) {
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setEngineErrorResponse(engineErrorResponse);
        apiResponse.code = code;
        apiResponse.msg = reason;
        apiResponse.headers = headers;
        return apiResponse;
    }

    public ApiException makeException() throws ApiException {
        String message = this.msg;
        int code = this.code;
        if (this.engineErrorResponse != null && this.engineErrorResponse.getMessage() != null) {
            message = this.engineErrorResponse.getMessage();
        }
        if (code == 409) {
            throw new ConflictException(message, code, this.headers, this.engineErrorResponse);
        }
        throw new ApiException(message, code, this.headers, this.engineErrorResponse);
    }

    public boolean isSuccessful() {
        return this.code >= 200 && this.code < 300;
    }

    public T getData() {
        return this.data;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public TaskflowErrorInformation getEngineErrorResponse() {
        return this.engineErrorResponse;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public void setEngineErrorResponse(TaskflowErrorInformation engineErrorResponse) {
        this.engineErrorResponse = engineErrorResponse;
    }

    public String toString() {
        return "ApiResponse(data=" + this.getData() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", headers=" + this.getHeaders() + ", engineErrorResponse=" + this.getEngineErrorResponse() + ")";
    }

    public ApiResponse() {
    }
}

