/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.open.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;

public class JsonUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    public static String serialize(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deserialize(String json, Class<T> clazz) throws IOException {
        return (T)mapper.readValue(json, clazz);
    }

    public static <T> List<T> fromJsonArray(String json, Class<T> clazz) throws IOException {
        return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, clazz));
    }

    public static void writeValue(Writer writer, Object object) throws IOException {
        mapper.writeValue(writer, object);
    }

    public static <T> T deserialize(String json, final Type type) {
        try {
            return (T)mapper.readerFor((TypeReference)new TypeReference<Object>(){

                public Type getType() {
                    return type;
                }
            }).readValue(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new ProtobufModule());
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        mapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        mapper.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, false);
        mapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
    }
}

