/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.config;

import cn.feiliu.taskflow.sdk.config.PropertyReader;
import cn.feiliu.taskflow.sdk.config.SystemPropertyReader;
import java.util.Optional;

class ApplicationPropertyReader
implements PropertyReader {
    private final String prefix;
    private final String propName;
    private final String workerName;
    private final SystemPropertyReader envWrapper;

    public ApplicationPropertyReader(String prefix, String propName, String workerName) {
        this.prefix = prefix;
        this.propName = propName;
        this.workerName = workerName;
        this.envWrapper = new SystemPropertyReader(prefix, propName, workerName);
    }

    private String getGlobalKey() {
        return this.prefix + "." + this.propName;
    }

    private String getWorkerKey() {
        return this.prefix + "." + this.workerName + "." + this.propName;
    }

    @Override
    public Integer getInteger(int defaultValue) {
        return Integer.parseInt(this.getString(Integer.toString(defaultValue)));
    }

    @Override
    public String getString(String defaultValue) {
        String result = System.getProperty(this.getWorkerKey());
        if (result != null) {
            return result;
        }
        Optional<String> optional = this.envWrapper.getString();
        if (optional.isPresent()) {
            return optional.get();
        }
        return System.getProperty(this.getGlobalKey(), defaultValue);
    }

    @Override
    public Boolean getBoolean(Boolean defaultValue) {
        String result = this.getString(defaultValue == null ? null : defaultValue.toString());
        if (result != null) {
            return Boolean.parseBoolean(result);
        }
        return defaultValue;
    }
}

