/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.config;

import cn.feiliu.taskflow.sdk.config.ApplicationPropertyReader;
import cn.feiliu.taskflow.sdk.config.PropertyReader;
import cn.feiliu.taskflow.sdk.config.SpringPropertyReader;
import java.util.concurrent.ConcurrentHashMap;

public class PropertyFactory {
    private static volatile boolean isSpringEnv = false;
    private static final String PROPERTY_PREFIX = "taskflow.worker";
    private static final ConcurrentHashMap<String, PropertyReader> PROPERTY_FACTORY_MAP = new ConcurrentHashMap();

    public static void enabledSpringEnv() {
        isSpringEnv = true;
    }

    private static PropertyReader getPropertyReader(String workerName, String propName) {
        String key = propName + "." + workerName;
        return PROPERTY_FACTORY_MAP.computeIfAbsent(key, t -> {
            if (isSpringEnv) {
                return new SpringPropertyReader(PROPERTY_PREFIX, workerName, propName);
            }
            return new ApplicationPropertyReader(PROPERTY_PREFIX, workerName, propName);
        });
    }

    public static Integer getInteger(String workerName, String property, Integer defaultValue) {
        return PropertyFactory.getPropertyReader(workerName, property).getInteger(defaultValue);
    }

    public static Boolean getBoolean(String workerName, String property, Boolean defaultValue) {
        return PropertyFactory.getPropertyReader(workerName, property).getBoolean(defaultValue);
    }

    public static String getString(String workerName, String property, String defaultValue) {
        return PropertyFactory.getPropertyReader(workerName, property).getString(defaultValue);
    }

    public static boolean getBooleanWithFallback(String workerName, String property, String fallbackName, boolean defaultValue) {
        Boolean discoveryOverride = PropertyFactory.getBoolean(workerName, property, null);
        if (discoveryOverride == null) {
            return PropertyFactory.getBoolean(fallbackName, property, defaultValue);
        }
        return discoveryOverride;
    }

    public static String getStringWithFallback(String workerName, String property, String fallbackName, String defaultValue) {
        String domain = PropertyFactory.getString(workerName, property, null);
        if (domain == null) {
            return PropertyFactory.getString(fallbackName, property, defaultValue);
        }
        return domain;
    }
}

