/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.config;

import cn.feiliu.taskflow.sdk.config.PropertyReader;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.core.env.Environment;

public class SpringPropertyReader
implements PropertyReader {
    private static final AtomicReference<Environment> envRef = new AtomicReference();
    private final String prefix;
    private final String propName;
    private final String workerName;

    public SpringPropertyReader(String prefix, String propName, String workerName) {
        this.prefix = prefix;
        this.propName = propName;
        this.workerName = workerName;
    }

    public static void init(Environment environment) {
        Objects.requireNonNull(environment, "Environment is required");
        envRef.set(environment);
    }

    private String getGlobalKey() {
        return this.prefix + "." + this.propName;
    }

    private String getWorkerKey() {
        return this.prefix + "." + this.workerName + "." + this.propName;
    }

    @Override
    public Integer getInteger(int defaultValue) {
        Integer result = (Integer)envRef.get().getProperty(this.getWorkerKey(), Integer.class);
        if (result == null) {
            return (Integer)envRef.get().getProperty(this.getGlobalKey(), Integer.class, (Object)defaultValue);
        }
        return result;
    }

    @Override
    public String getString(String defaultValue) {
        String result = envRef.get().getProperty(this.getWorkerKey());
        if (result == null) {
            return envRef.get().getProperty(this.getGlobalKey(), defaultValue);
        }
        return result;
    }

    @Override
    public Boolean getBoolean(Boolean defaultValue) {
        Boolean result = (Boolean)envRef.get().getProperty(this.getWorkerKey(), Boolean.class);
        if (result == null) {
            return (Boolean)envRef.get().getProperty(this.getGlobalKey(), Boolean.class, (Object)defaultValue);
        }
        return result;
    }
}

