/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.config;

import java.util.Optional;

class SystemPropertyReader {
    private final String prefix;
    private final String propName;
    private final String workerName;

    public SystemPropertyReader(String prefix, String propName, String workerName) {
        this.prefix = prefix;
        this.propName = propName;
        this.workerName = workerName;
    }

    private String getGlobalKey() {
        return this.prefix + "_" + this.propName;
    }

    private String getWorkerKey() {
        return this.prefix + "_" + this.workerName + "_" + this.propName;
    }

    public Optional<Integer> getInteger() {
        Optional<String> optional = this.getString();
        return optional.map(res -> Integer.parseInt(res));
    }

    public Optional<String> getString() {
        String result = System.getenv(this.getWorkerKey());
        if (result == null) {
            result = System.getenv(this.getGlobalKey());
        }
        return Optional.ofNullable(result);
    }

    public Optional<Boolean> getBoolean() {
        Optional<String> result = this.getString();
        return result.map(res -> Boolean.parseBoolean(res));
    }
}

